// Fill out your copyright notice in the Description page of Project Settings.


#include "PC_PayPannel.h"

#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSupportKit.h"

#include "LogHeroUsdk.h"
#include "DotManager/DotManager.h"
#include "Setting/UsdkSettings.h"
#include "Tools/UsdkCommonTools.h"
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
#include "Manager/HeroUsdkSupportPcDelegate.h"
#endif





void UPC_PayPannel::OnLoadCompletedImp()
{
	Super::OnLoadCompletedImp();
	UWebBrowser_0->ExecuteJavascript("document.body.style.background = 'white'");
}

void UPC_PayPannel::OnBeforeNavigationImp(const FString& Url)
{
	if(Url.Contains("code:[success:exit]") ||Url.Contains("code%3A%5Bsuccess%3Aexit%5D") ||Url.Contains("code:%5Bsuccess:exit%5D"))
	{
		auto Param = FGenericPlatformHttp::GetUrlParameter(Url, TEXT("status"));
		if(Param.IsSet())
		{
			HandleXsollaCallBack(Param.GetValue());
		}
	}
}


//获取支付地址
FString UPC_PayPannel::GetOfficePayUrl(FString BaseUrl)
{

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	
   

	FString CoinType = PayOrderResult.currency;
	FString GoodsId = PaymentParameters.goodsId;
    FString goodsName =PayOrderResult.goodsName ;
    FString goodsIcon =PayOrderResult.gameIcon ;
    FString goodsNum =FString::FromInt(PayOrderResult.goodsNum) ;
    FString amount =FString::SanitizeFloat( PayOrderResult.price)  ;
    FString order = PayOrderResult.order ;
    FString cpOrder = PaymentParameters.cpOrder ;
    BaseUrl += FString::Printf(TEXT("loginName=%s&"), *HeroUsdkSupportPcDelegate::GetInstance()->GetUserInfo().userName);
    BaseUrl += FString::Printf(TEXT("accessToken=%s&"), *HeroUsdkSupportPcDelegate::GetInstance()->GetChannelToken());
    

	FString roleId = HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleId ;

	
   
    FString gameNameEncode = FGenericPlatformHttp::UrlEncode(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig()->gameName);
    BaseUrl += FString::Printf(TEXT("gameName=%s&"), *gameNameEncode);
    
    if (!HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleName.IsEmpty())
    {
    	FString roleNameEncode = FGenericPlatformHttp::UrlEncode(HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo().roleName);
    	BaseUrl += FString::Printf(TEXT("roleName=%s&"), *roleNameEncode);
    }
    if (!goodsName.IsEmpty())
    {
    	FString goodsNameEncode = FGenericPlatformHttp::UrlEncode(goodsName);
    	BaseUrl += FString::Printf(TEXT("goodsName=%s&"), *goodsNameEncode);
    }
    if (!goodsIcon.IsEmpty())
    {
    	FString goodsIconEncode = FGenericPlatformHttp::UrlEncode(goodsIcon);
    	BaseUrl += FString::Printf(TEXT("goodsIcon=%s&"), *goodsIcon);
    }
    if (!goodsNum.IsEmpty())
    {
    	FString goodsNumEncode = FGenericPlatformHttp::UrlEncode(goodsNum);
    	BaseUrl += FString::Printf(TEXT("count=%s&"), *goodsNumEncode);
    }
    if (!amount.IsEmpty())
    {
    	FString amountEncode = FGenericPlatformHttp::UrlEncode(amount);
    	BaseUrl += FString::Printf(TEXT("price=%s&"), *amountEncode);
    }
    if (!order.IsEmpty())
    {
    	FString orderEncode = FGenericPlatformHttp::UrlEncode(order);
    	BaseUrl += FString::Printf(TEXT("order=%s&"), *orderEncode);
    }
    if (!cpOrder.IsEmpty())
    {
    	FString cpOrderEncode = FGenericPlatformHttp::UrlEncode(cpOrder);
    	BaseUrl += FString::Printf(TEXT("cpOrder=%s&"), *cpOrderEncode);
    }
    if (!roleId.IsEmpty())
    {
    	FString roleIdEncode = FGenericPlatformHttp::UrlEncode(roleId);
    	BaseUrl += FString::Printf(TEXT("roleId=%s&"), *roleIdEncode);
    }
	if (!GoodsId.IsEmpty())
	{
		FString GoodsIdEncode = FGenericPlatformHttp::UrlEncode(GoodsId);
		BaseUrl += FString::Printf(TEXT("goodsId=%s&"), *GoodsId);
	}
	if (!CoinType.IsEmpty())
	{
		FString CoinTypeEncode = FGenericPlatformHttp::UrlEncode(CoinType);
		BaseUrl += FString::Printf(TEXT("coinType=%s&"), *CoinType);
	}
    FString timestamp = FUsdkCommonTools::GetTimestamp();
    BaseUrl += FString::Printf(TEXT("orderTime=%s"), *timestamp);
    BaseUrl = FUsdkCommonTools::AppendUrlTimestampFix(BaseUrl);
    
    	
    
	UE_LOG(LogHeroUsdk, Log, TEXT("GetPayUrl %s"), *BaseUrl);
    return BaseUrl ;

#endif

	return "" ;
}

//获取支付地址
FString UPC_PayPannel::GetXsollaPayUrl(FString BaseUrl)
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	FString CoinType = PayOrderResult.currency;
    FString GoodsId = PaymentParameters.goodsId;
   	FString order =  PayOrderResult.order;
   	FString cpOrder = PaymentParameters.cpOrder ;

	const FHeroHDCGameRoleInfo RoleInfo = HeroUsdkSupportPcDelegate::GetInstance()->GetRoleInfo();

	FString ServerId = RoleInfo.serverId;
	if (!ServerId.IsEmpty())
	{
		FString ServerIdEncode = FGenericPlatformHttp::UrlEncode(ServerId);
		BaseUrl += FString::Printf(TEXT("serverId=%s&"), *ServerIdEncode);
	}
    if (!order.IsEmpty())
    {
    	FString orderEncode = FGenericPlatformHttp::UrlEncode(order);
    	BaseUrl += FString::Printf(TEXT("order=%s&"), *orderEncode);
    }
	if (!cpOrder.IsEmpty())
	{
		FString cpOrderEncode = FGenericPlatformHttp::UrlEncode(cpOrder);
		BaseUrl += FString::Printf(TEXT("cpOrder=%s&"), *cpOrderEncode);
	}
	if (!GoodsId.IsEmpty())
	{
		FString GoodsIdEncode = FGenericPlatformHttp::UrlEncode(GoodsId);
		BaseUrl += FString::Printf(TEXT("goodsId=%s&"), *GoodsIdEncode);
	}
	if (!CoinType.IsEmpty())
	{
		FString CoinTypeEncode = FGenericPlatformHttp::UrlEncode(CoinType);
		BaseUrl += FString::Printf(TEXT("coinType=%s&"), *CoinType);
	}
    FString ServerName = RoleInfo.serverName;
	if (!ServerName.IsEmpty())
	{
		FString ServerNameEncode = FGenericPlatformHttp::UrlEncode(ServerName);
		BaseUrl += FString::Printf(TEXT("serverName=%s"), *ServerNameEncode);
	}

    UE_LOG(LogHeroUsdk, Log, TEXT("GetXsollaPayUrl %s"), *BaseUrl);
    return BaseUrl;

#else
	return "" ;
#endif
}


void UPC_PayPannel::HandleJSCallBack(FString data) 
{
	
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	
	UE_LOG(LogHeroUsdk, Log, TEXT("HandleJSCallBack data %s"), *data);
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(data);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		FString urlStr = JsonObject->GetStringField(TEXT("url")) ;
		if (!urlStr.IsEmpty())
		{
			if (urlStr.Equals("v1/pay/success"))
			{
				TMap<FString,FString> paramter ;
				paramter.Add("plat","pc");
			
					
			
				FString amount = FString::SanitizeFloat(PayOrderResult.price) ;
				FString order = PayOrderResult.order;
				FString currency = PayOrderResult.currency ;
				paramter.Add("sdkOrderId",order);
				paramter.Add("orderAmount",amount);
				paramter.Add("currency",currency);
				FString payResultJSON = FUsdkCommonTools::converMapToString(paramter);
				if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
				{
					{
						TMap<FString,FString> DotParam;
						DotParam.Emplace("goods_id",PaymentParameters.goodsId);
						DotParam.Emplace("goods_name",PayOrderResult.goodsName);
						DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
						DotParam.Emplace("amount",PayOrderResult.goodsDesc);
						DotParam.Emplace("coin_type",PayOrderResult.currency);
						DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
						DotParam.Emplace("result","1");
						DotParam.Emplace("reason","");
						DotParam.Emplace("usdk_order",PayOrderResult.order);
						DotParam.Emplace("channel_order","");
						FDotManager::GetInstance().CallDot("u_p_getpaymsg",DotParam);
						FDotManager::GetInstance().CallDot("u_p_backpaymsg_tocp",DotParam);
					}
					HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkSuccess,payResultJSON,TEXT("Pay Success")) ;
				}
				//关闭支付界面
				RemoveFromParent() ;
				return ;
					
				
			}
			else if(urlStr=="v1/pay/placeOrderError")
			{
				auto obj = JsonObject->GetObjectField("data");
				int32 code = obj->GetIntegerField("code");
				FString msg = obj->GetStringField("message");
				TMap<FString,FString> paramter ;
				paramter.Add("plat","pc");
				paramter.Add("code",FString::FromInt(code));
				paramter.Add("msg",msg);
				FString cpOrder = PaymentParameters.cpOrder ;
				if (!cpOrder.IsEmpty())
				{
					paramter.Add("cpOrderId",cpOrder);
				}
				FString paramterString = FUsdkCommonTools::converMapToString(paramter);
				if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
				{
					{
						TMap<FString,FString> DotParam;
						DotParam.Emplace("goods_id",PaymentParameters.goodsId);
						DotParam.Emplace("goods_name",PayOrderResult.goodsName);
						DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
						DotParam.Emplace("amount",PayOrderResult.goodsDesc);
						DotParam.Emplace("coin_type",PayOrderResult.currency);
						DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
						DotParam.Emplace("result","0");
						DotParam.Emplace("reason",urlStr);
						DotParam.Emplace("usdk_order",PayOrderResult.order);
						DotParam.Emplace("channel_order","");
						FDotManager::GetInstance().CallDot("u_p_backpaymsg_tocp",DotParam);
					}
					HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,paramterString,paramterString);
				}
				RemoveFromParent();
				return ;
			}
			else if(urlStr=="v1/pay/params")
			{
				return;
			}
		}
		
	}
	if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
	{
		{
			TMap<FString,FString> DotParam;
			DotParam.Emplace("goods_id",PaymentParameters.goodsId);
			DotParam.Emplace("goods_name",PayOrderResult.goodsName);
			DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
			DotParam.Emplace("amount",PayOrderResult.goodsDesc);
			DotParam.Emplace("coin_type",PayOrderResult.currency);
			DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
			DotParam.Emplace("result","0");
			DotParam.Emplace("reason", FString("json parse error")+data);
			DotParam.Emplace("usdk_order",PayOrderResult.order);
			DotParam.Emplace("channel_order","");
			FDotManager::GetInstance().CallDot("u_p_backpaymsg_tocp",DotParam);
		}
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkFailed,"",TEXT("支付失败,请稍后重试")) ;
	}

#endif
	
}

void UPC_PayPannel::HandleXsollaCallBack(const FString& data)
{
	if (data.Equals("done", ESearchCase::IgnoreCase))
	{
		TMap<FString,FString> paramter ;
		paramter.Add("plat","pc");
	
		
		FString amount = FString::SanitizeFloat(PayOrderResult.price);
		FString order = PayOrderResult.order ;
		FString currency = PayOrderResult.currency ;
		paramter.Add("sdkOrderId",order);
		paramter.Add("orderAmount",amount);
		paramter.Add("currency",currency);
		FString payResultJSON = FUsdkCommonTools::converMapToString(paramter);
		if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
		{
			{
				TMap<FString,FString> DotParam;
				DotParam.Emplace("goods_id",PaymentParameters.goodsId);
				DotParam.Emplace("goods_name",PayOrderResult.goodsName);
				DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
				DotParam.Emplace("amount",PayOrderResult.goodsDesc);
				DotParam.Emplace("coin_type",PayOrderResult.currency);
				DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
				DotParam.Emplace("usdk_order",PayOrderResult.order);
				DotParam.Emplace("channel_order","");
				DotParam.Emplace("result","1");
				DotParam.Emplace("reason","");
				FDotManager::GetInstance().CallDot("g_p_backpaymsg_tou",DotParam);
				FDotManager::GetInstance().CallDot("u_p_getpaymsg",DotParam);
				FDotManager::GetInstance().CallDot("u_p_backpaymsg_tocp",DotParam);
			}
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkSuccess,payResultJSON,TEXT("Pay Success")) ;
		}

		//关闭支付界面
		RemoveFromParent() ;
		return ;
			
		
	}
	else
	{
		TMap<FString,FString> paramter ;
		paramter.Add("plat","pc");
		paramter.Add("msg",TEXT("Pay Cancel"));
		FString cpOrder = PaymentParameters.cpOrder ;
		if (!cpOrder.IsEmpty())
		{
			paramter.Add("cpOrderId",cpOrder);
		}
		FString paramterString = FUsdkCommonTools::converMapToString(paramter);
		if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
		{
			{
				TMap<FString,FString> DotParam;
				DotParam.Emplace("goods_id",PaymentParameters.goodsId);
				DotParam.Emplace("goods_name",PayOrderResult.goodsName);
				DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
				DotParam.Emplace("amount",PayOrderResult.goodsDesc);
				DotParam.Emplace("coin_type",PayOrderResult.currency);
				DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
				DotParam.Emplace("result","0");
				DotParam.Emplace("reason", FString("json parse error")+data);
				DotParam.Emplace("usdk_order",PayOrderResult.order);
				DotParam.Emplace("channel_order","");
				FDotManager::GetInstance().CallDot("u_p_backpaymsg_tocp",DotParam);
			}
			HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkCancel,paramterString,TEXT("Pay Cannel"));
		}
		return ;
	}
	
}

void UPC_PayPannel::OnCloseClickedImp()
{
	TMap<FString,FString> paramter ;
	paramter.Add("plat","pc");
	paramter.Add("msg",TEXT("Pay Cancel"));
	FString cpOrder = PaymentParameters.cpOrder ;
	if (!cpOrder.IsEmpty())
	{
		paramter.Add("cpOrderId",cpOrder);
	}
	FString paramterString = FUsdkCommonTools::converMapToString(paramter);
	if (HeroUsdkSupportKit::GetInstance().NotifyObject != nullptr)
	{
		{
			TMap<FString,FString> DotParam;
			DotParam.Emplace("goods_id",PaymentParameters.goodsId);
			DotParam.Emplace("goods_name",PayOrderResult.goodsName);
			DotParam.Emplace("goods_info",PayOrderResult.goodsDesc);
			DotParam.Emplace("amount",PayOrderResult.goodsDesc);
			DotParam.Emplace("coin_type",PayOrderResult.currency);
			DotParam.Emplace("cp_order",PaymentParameters.cpOrder);
			DotParam.Emplace("result","0");
			DotParam.Emplace("reason", "user cancel");
			DotParam.Emplace("usdk_order",PayOrderResult.order);
			DotParam.Emplace("channel_order","");
			FDotManager::GetInstance().CallDot("u_p_backpaymsg_tocp",DotParam);
		}
		HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onPayCallBack(HeroUsdkCancel,paramterString,TEXT("Pay Cannel"));
	}
	Super::OnCloseClickedImp();
}

FString UPC_PayPannel::GetLocalUrl()
{
	auto setting = GetMutableDefault<UUsdkSettings>();
	if(setting->Channel==EHeroUSDKChannel::China)
	{
		FString LocalUrl = FPaths::Combine(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager()->GetChannelWebDir(),  TEXT("index.html#/pay?")) ;
		return GetOfficePayUrl(LocalUrl);
	}
	else
	{
		FString LocalUrl = FPaths::Combine(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager()->GetChannelWebDir(),  TEXT("index.html#/global-pay?")) ;
		return GetXsollaPayUrl(LocalUrl);
	}
}

FString UPC_PayPannel::GetRemoteUrl()
{
	auto setting = GetMutableDefault<UUsdkSettings>();
	if(setting->Channel==EHeroUSDKChannel::China)
	{
		FString baseUrl = HeroUsdkSupportPcDelegate::GetInstance()->GetEnvMode()->GetPcUrl()  + TEXT("#/pay?") ;
		return GetOfficePayUrl(baseUrl);
	}
	else
	{
		FString baseUrl =FPaths::Combine(HeroUsdkSupportPcDelegate::GetInstance()->GetEnvMode()->GetPcUrl(),TEXT("#/global-pay?"));
		return GetXsollaPayUrl(baseUrl);
	}
}
