// Fill out your copyright notice in the Description page of Project Settings.

#include "PC_ProtocolPannel.h"
#include "Manager/Usdk/UsdkManager.h"
#include "HeroUsdkSupportKit.h"
#include "Http.h"
#include "LogHeroUsdk.h"
#include "Blueprint/WidgetBlueprintLibrary.h"
#include "DotManager/DotManager.h"
#include "Kismet/GameplayStatics.h"
#include "Setting/UsdkSettings.h"
#include "Tools/UsdkCommonTools.h"

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
#include "Manager/HeroUsdkSupportPcDelegate.h"
#endif



void UPC_ProtocolPannel::NativeConstruct()
{
	Super::NativeConstruct();
	auto PlayerController = UGameplayStatics::GetPlayerController(this,0);
	UWidgetBlueprintLibrary::SetInputMode_UIOnlyEx(PlayerController,this,EMouseLockMode::LockOnCapture);
	this->SetFocus();
}



void UPC_ProtocolPannel::HandleJSCallBack(FString data)
{

#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(data);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		const TSharedPtr<FJsonValue>* urlValue = JsonObject->Values.Find(TEXT("url"));
		if (urlValue->IsValid())
		{
			FString urlStr = (*urlValue)->AsString();
			if (urlStr.Equals("v1/protcol/agree"))
			{
				FDotManager::GetInstance().CallDot("u_click_deal",{{"type","1"}});
				FDotManager::GetInstance().CallDot("u_deal_result",{{"type","1"}});
				if(HeroUsdkSupportPcDelegate::GetInstance()->bIsInitAgreement)
				{
					//标记已经显示协议
					FUsdkCommonTools::WriteText("usdk_proto_agree", "true");
					HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onProtocolAgree();
					HeroUsdkSupportPcDelegate::GetInstance()->ChannelInit();
				}
				else
				{
					//标记已经显示协议
					FUsdkCommonTools::WriteText("global_agree", "true");
					HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onInitCallBack(HeroUsdkSuccess,{});
				}
				
				//同意协议,移除界面
				RemoveFromParent();
			}
			else if (urlStr.Equals("v1/protcol/disagree"))
			{
				FDotManager::GetInstance().CallDot("u_click_deal",{{"type","0"}});
				FDotManager::GetInstance().CallDot("u_deal_result",{{"type","0"}});

				HeroUsdkSupportKit::GetInstance().NotifyObject->usdk_onExitCallBack(HeroUsdkSuccess, TEXT("拒绝协议"));
				UKismetSystemLibrary::QuitGame(this,nullptr,EQuitPreference::Quit,false);
			}
		}
	}

#endif
	
}



FString UPC_ProtocolPannel::GetLocalUrl()
{
	auto BaseUrl = HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager()->GetChannelWebDir();
	FString LocalUrl = FPaths::Combine(BaseUrl,  TEXT("index.html#/agreement")) ;
	UE_LOG(LogHeroUsdk,Log,TEXT("load Local login url:%s"),*LocalUrl);
	return LocalUrl;
}

FString UPC_ProtocolPannel::GetRemoteUrl()
{
	auto PcUrl = HeroUsdkSupportPcDelegate::GetInstance()->GetEnvMode()->GetPcUrl();
	auto RemoteUrl = FPaths::Combine(PcUrl,TEXT("#"),TEXT("agreement"));
	return RemoteUrl;
}

