#include "PC_SurveyPanel.h"

#include "HeroUsdkSupportKit.h"
#include "Manager/Usdk/UsdkManager.h"
#include "LogHeroUsdk.h"
#include "Kismet/KismetSystemLibrary.h"


void UPC_SurveyPanel::Start()
{
	Super::Start();
	Button_Back->OnClicked.AddDynamic(this,&UPC_SurveyPanel::HandleBackClicked);
	Button_Forward->OnClicked.AddDynamic(this,&UPC_SurveyPanel::HandleForwardClicked);
	Button_Refresh->OnClicked.AddDynamic(this,&UPC_SurveyPanel::HandleRefreshClicked);
}

FString UPC_SurveyPanel::GetUrl()
{
	return Url;
}

void UPC_SurveyPanel::HandleJSCallBack(FString data)
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	UE_LOG(LogHeroUsdk, Log, TEXT("UPC_SurveyPanel::HandleJSCallBack data %s"), *data);
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	const TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(data);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		const FString URLStr = JsonObject->GetStringField(TEXT("url"));
		if (URLStr.Equals("v1/actioin/close"))
		{
			this->OnCloseClickedImp();
		}
		else if(URLStr==TEXT("invokeSdkMethod"))
		{
			auto Obj = JsonObject->GetObjectField(TEXT("data"));
			if(Obj)
			{
				auto methodsName =  Obj->GetStringField(TEXT("methodsName"));
				if(methodsName == TEXT("close"))
				{
					if(bIsCancelAccountSuccess)
					{
						if (GetMutableDefault<UUsdkSettings>()->Channel == EHeroUSDKChannel::WeGame)
						{
							UKismetSystemLibrary::QuitGame(this,nullptr,EQuitPreference::Quit,false);
						}
						HeroUsdkSupportKit::GetInstance().logout();
					}
					RemoveFromParent();
				}
				else if(methodsName == TEXT("cancelSuccess"))
				{
					bIsCancelAccountSuccess = true;
				}
			}
		}
		
		else
		{
			UE_LOG(LogHeroUsdk, Error, TEXT("JSON deserialization failed"));
		}
	}
#endif
}

void UPC_SurveyPanel::HandleBackClicked()
{
	UWebBrowser_0->GoBack();
	if (!UWebBrowser_0->CanGoBack())
	{
	}
}

void UPC_SurveyPanel::HandleForwardClicked()
{
	UWebBrowser_0->GoForward();
	if (!UWebBrowser_0->CanGoForward())
	{
	}
}

void UPC_SurveyPanel::HandleRefreshClicked()
{
	UWebBrowser_0->Reload();
}

void UPC_SurveyPanel::OnLoadCompletedImp()
{
	if(isFirstTime)
	{
		isFirstTime = false;
		UWebBrowser_0->Reload();
	}
	
}

void UPC_SurveyPanel::OnCloseClickedImp()
{
	if(bIsCancelAccountSuccess)
	{
		HeroUsdkSupportKit::GetInstance().logout();
	}
	Super::OnCloseClickedImp();
}
