// Fill out your copyright notice in the Description page of Project Settings.


#include "PC_SwitchAccountPannel.h"
#include "LogHeroUsdk.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "Tools/UsdkCommonTools.h"


FString UPC_SwitchAccountPannel::GetLocalUrl()
{
	FString LocalUrl = FPaths::Combine(HeroUsdkSupportPcDelegate::GetInstance()->GetChannelManager()->GetChannelWebDir(),  TEXT("index.html#/switch-account")) ;
	UE_LOG(LogHeroUsdk,Log,TEXT("load Local UPC_SwitchAccountPannel url:%s"),*LocalUrl);
	return LocalUrl;
}

FString UPC_SwitchAccountPannel::GetRemoteUrl()
{
	const FString BaseUrl = HeroUsdkSupportPcDelegate::GetInstance()->GetEnvMode()->GetPcUrl() ;
	FString FullUrl = FPaths::Combine(BaseUrl,TEXT("switch-account"));
	FullUrl =  FUsdkCommonTools::AppendUrlTimestampFix(FullUrl);
	UE_LOG(LogHeroUsdk, Log, TEXT("UPC_SwitchAccountPannel remote url %s"), *FullUrl);
	return FullUrl ;
}
