// Fill out your copyright notice in the Description page of Project Settings.


#include "UsdkBaseWidget.h"

#include "HeroUsdkSupportKit.h"
#include "LogHeroUsdk.h"
#include "Blueprint/WidgetBlueprintLibrary.h"
#include "Components/Button.h"
#include "DotManager/DotManager.h"
#include "Kismet/GameplayStatics.h"
#include "Kismet/KismetSystemLibrary.h"
#include "Manager/HeroUsdkSupportPcDelegate.h"
#include "Misc/FileHelper.h"
#include "Setting/UsdkSettings.h"
#include "Tools/UsdkCommonTools.h"
#include "Tools/UsdkWebTools.h"

DECLARE_LOG_CATEGORY_EXTERN(LogUsdkWeb, Log, All);
DEFINE_LOG_CATEGORY(LogUsdkWeb);

constexpr float LoadLimit = 29.f;
constexpr float WebPageLoadTimeout = 30.0f;

TMap<FString, FString> UUsdkBaseWidget::FilledMap;
bool UUsdkBaseWidget::IsRemoteUrl = false;

void UUsdkBaseWidget::NativeConstruct()
{
	Super::NativeConstruct();
	Start();
}

void UUsdkBaseWidget::Start()
{
	
	UWebBrowser_0->OnUrlChanged.AddDynamic(this,&UUsdkBaseWidget::OnUrlChanged);
	UWebBrowser_0->OnBeforePopup.AddDynamic(this,&UUsdkBaseWidget::OnBeforePopup);
	UWebBrowser_0->OnLoadCompleted.AddDynamic(this,&UUsdkBaseWidget::OnLoadCompleted);
	UWebBrowser_0->OnBeforeNavigation.AddDynamic(this,&UUsdkBaseWidget::OnBeforeNavigation);
	UWebBrowser_0->OnLoadStarted.AddDynamic(this,&UUsdkBaseWidget::HandleOnLoadStarted);
	UWebBrowser_0->OnLoadError.AddDynamic(this,&UUsdkBaseWidget::HandleWebPageLoadTimeout);
	UWebBrowser_0->BindUObject(TEXT("obj"),this,true);
	Button_Close->OnClicked.AddDynamic(this,&UUsdkBaseWidget::OnCloseClicked);
	Button_Close->SetVisibility(ESlateVisibility::Hidden);
	UWebBrowser_0->LoadURL(GetUrl());
	/*const auto playerController = UGameplayStatics::GetPlayerController(this,0);
	UWidgetBlueprintLibrary::SetInputMode_UIOnlyEx(playerController,this);*/
}

void UUsdkBaseWidget::NativeTick(const FGeometry& MyGeometry, float InDeltaTime)
{
	Super::NativeTick(MyGeometry, InDeltaTime);
	if(bCanCountDown)
	{
		CloseBtnShowTime+=InDeltaTime;
		if(CloseBtnShowTime>3.f)
		{
			Button_Close->SetVisibility(ESlateVisibility::Visible);
			bCanCountDown= false;
		}
	}

	if(IsCounting && !IsRemoteUrl)
	{
		LoadDuration+=InDeltaTime;
		if(LoadDuration>LoadLimit)
		{
			JumpToRemoteUrl();
			LoadDuration = 0.f;
			IsCounting = false;
		}
	}
} 

void UUsdkBaseWidget::OnCloseClicked()
{
	OnCloseClickedImp();
}

void UUsdkBaseWidget::OnUrlChanged(const FText& Text)
{
	FString Url = Text.ToString();
	bCanCountDown= true;
	CloseBtnShowTime = 0.f;
	//UWebBrowser_0->ExecuteJavascript(GetJsParam());
	//UKismetSystemLibrary::PrintString(this,FString::Printf(TEXT("on url changed:,%s"),*Text.ToString()));
}

void UUsdkBaseWidget::OnBeforePopup(FString URL, FString Frame)
{
	UWebBrowser_0->LoadURL(URL);
}

void UUsdkBaseWidget::OnLoadCompleted()
{
	UWebBrowser_0->BindUObject(TEXT("obj"),this,true);
	GetWorld()->GetTimerManager().ClearTimer(WebPageLoadTimerHandle);
	OnLoadCompletedImp();
}

void UUsdkBaseWidget::OnBeforeNavigation(const FString& Url)
{
	UE_LOG(LogHeroUsdk,Log,TEXT("OnBeforeNavigation:%s"),*Url);
	OnBeforeNavigationImp(Url);
}

void UUsdkBaseWidget::invokeUE(FString data)
{
	UE_LOG(LogHeroUsdk,Log,TEXT("invokeUE:%s"),*data);
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(data);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		FString urlStr = JsonObject->GetStringField(TEXT("url")) ;
		if (!urlStr.IsEmpty())
		{
			if(urlStr == TEXT("v1/point/buried"))
			{
				UE_LOG(LogUsdkWeb,Log,TEXT("web dot:%s"),*data);
				const auto dataObj = JsonObject->GetObjectField("data");
				if(dataObj.IsValid())
				{
					const auto eventName = dataObj->GetStringField("event");
					TMap<FString,FString> Param;
					const auto param = dataObj->GetObjectField("params");
					FDotManager::GetInstance().CallWebDot(eventName,param);
				}
			}
			else if(urlStr == TEXT("v1/web/log"))
			{
				UE_LOG(LogUsdkWeb,Log,TEXT("%s"),*JsonObject->GetStringField("data"));
			}
			else if(urlStr == TEXT("v1/close/btn/show"))
			{
				bCanCountDown= false;
				Button_Close->SetVisibility(ESlateVisibility::Visible);
				UE_LOG(LogTemp,Log,TEXT("invokeUE :%s"),*urlStr);
			}
			else if(urlStr == TEXT("v1/close/btn/hide"))
			{
				bCanCountDown= false;
				Button_Close->SetVisibility(ESlateVisibility::Hidden);
				UE_LOG(LogTemp,Log,TEXT("invokeUE :%s"),*urlStr);
			}
			else if(urlStr == TEXT("v1/actioin/close"))
			{
				RemoveFromParent();
			}
			else if(urlStr.Equals("v1/login/loadSuccess"))
			{
				LoadDuration = 0.f;
				IsCounting = false;
			}
			else if(urlStr.Equals("v1/wegame/unbindSuccess"))
			{
				HeroUsdkSupportKit::GetInstance().logout();
				HeroUsdkSupportKit::GetInstance().login();
				RemoveFromParent();
			}
			else
			{
				HandleJSCallBack(data);
			}
		}
	}
}

FString UUsdkBaseWidget::GetUeDataInteral(const FString& Key)
{
	if(FilledMap.Find(Key))
	{
		return FilledMap[Key];
	}
	
	if(Key == TEXT("INIT_DATA_GLOBAL"))
	{
		FString GlobalConfig = FUsdkCommonTools::ReadTextByPath("GlobalInitConfig");
		if(!GlobalConfig.Len())
		{
			auto setting = GetMutableDefault<UUsdkSettings>();
			GlobalConfig = GetMutableDefault<UUsdkSettings>()->GlobalInitConfig;
		}
		FilledMap.Add(Key,GlobalConfig);
		return GlobalConfig;
	}
	
	if(Key == TEXT("APP_DATA_GLOBAL"))
	{
		auto Config = HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig();
		auto params = Config->GetJsParameter();
		return FUsdkCommonTools::converMapToString(params);
	}
	
	if(Key == TEXT("INIT_DATA_INTERNAL"))
	{
		FString ChinaInitConfig = FUsdkCommonTools::ReadTextByPath("ChinaInitConfig");
		if(!ChinaInitConfig.Len())
		{
			auto setting = GetMutableDefault<UUsdkSettings>();
			ChinaInitConfig = GetMutableDefault<UUsdkSettings>()->ChinaInitConfig;
		}
		FilledMap.Add(Key,ChinaInitConfig);
		return ChinaInitConfig;
		
	}

	if(Key == TEXT("USDK_INIT_DATA_INTERNAL"))
	{
		FString UsdkInitConfig = FUsdkCommonTools::ReadTextByPath("UsdkInitConfig");
		if(!UsdkInitConfig.Len())
		{
			auto setting = GetMutableDefault<UUsdkSettings>();
			UsdkInitConfig = GetMutableDefault<UUsdkSettings>()->UsdkInitConfig;
		}
		FilledMap.Add(Key,UsdkInitConfig);
		return UsdkInitConfig;
		
	}

	if(Key == TEXT("APP_DATA_INTERNAL"))
	{
		auto Config = HeroUsdkSupportPcDelegate::GetInstance()->GetChannelConfig();
		auto params = Config->GetJsParameter();
		return FUsdkCommonTools::converMapToString(params);
	}


	auto Result = FUsdkWebTools::ReadTextByPath(Key);
	if(!Result.IsEmpty())
	{
		FilledMap.Emplace(Key,Result);
		return Result;
	}
	return "{}";
}

FString UUsdkBaseWidget::getUeData(const FString& Key)
{
	FString Result= GetUeDataInteral(Key);
	UE_LOG(LogHeroUsdk,Warning,TEXT("Web GetUE data,key:%s,value:%s"),*Key,*Result);
	return Result;
}

void UUsdkBaseWidget::SetUeDataInteral(const FString& Key, const FString& Value)
{
	if(Value.IsEmpty())
	{
		FilledMap.Remove(Key);
		FUsdkWebTools::DeleteText(Key);
	}
	else
	{
		FilledMap.Emplace(Key,Value);
		FUsdkWebTools::WriteText(Key,Value);
	}
}

bool UUsdkBaseWidget::setUeData(const FString& Key, const FString& Value)
{
	UE_LOG(LogHeroUsdk,Warning,TEXT("Web GetUE data,key:%s,value:%s"),*Key,*Value);
	SetUeDataInteral(Key, Value);
	return true;
}

void UUsdkBaseWidget::close(FString data)
{
	OnWebClose(data);
}

void UUsdkBaseWidget::OnWebClose(FString data)
{
	TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject);
	TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(data);
	if (FJsonSerializer::Deserialize(Reader, JsonObject))
	{
		FString type = JsonObject->GetStringField(TEXT("type")) ;
		if (!type.IsEmpty() && type == TEXT("cancel"))
		{
			OnCloseClickedImp();
			return;
		}
	}
	IsCounting = false;
	RemoveFromParent();
}

void UUsdkBaseWidget::HandleOnLoadStarted()
{
	GetWorld()->GetTimerManager().SetTimer(WebPageLoadTimerHandle, this, &UUsdkBaseWidget::HandleWebPageLoadTimeout, WebPageLoadTimeout, false);
}

void UUsdkBaseWidget::launchURL(const FString& URL)
{
	UKismetSystemLibrary::LaunchURL(URL);
}

void UUsdkBaseWidget::HandleWebPageLoadTimeout()
{
	UWebBrowser_0->StopLoad();
	auto parent = this->GetOuter();
	if(parent)
	{
		LaunchLocalErrorPage();
	}
	UE_LOG(LogTemp, Warning, TEXT("Web page load timed out."));
}

void UUsdkBaseWidget::JumpURL(const FString& URL)
{
	UWebBrowser_0->LoadURL(URL);
}

FString UUsdkBaseWidget::GetUrl()
{
#if  PLATFORM_MAC || PLATFORM_WINDOWS || PLATFORM_LINUX
	IsCounting = true;
	if(IsRemoteUrl)
	{
		return GetRemoteUrl();
	}
	else
	{
		return GetLocalUrl();
	}
#else
	return "";
#endif
}

void UUsdkBaseWidget::OnLoadCompletedImp()
{
	//UE_LOG(LogHeroUsdk,Log,TEXT("Start ExecuteJavascript"))
	//UWebBrowser_0->ExecuteJavascript(GetJsParam());
}

void UUsdkBaseWidget::OnCloseClickedImp()
{
	RemoveFromParent();
}

void UUsdkBaseWidget::JumpToRemoteUrl()
{
	IsRemoteUrl = true;
	UWebBrowser_0->StopLoad();
	auto RemoteUrl = GetRemoteUrl();
	UKismetSystemLibrary::PrintString(this,  FString::Printf(TEXT("call remote Url:%s"),*RemoteUrl),
		true,true,FLinearColor(1.0, 1.0, 0.0),10.f);
	UWebBrowser_0->LoadURL(RemoteUrl);
}


#define FILE_NETWORK_ERROR TEXT("network_error.html")

void UUsdkBaseWidget::LaunchLocalErrorPage()
{
	UWebBrowser_0->StopLoad();
	if(IsRemoteUrl)
	{
		const FString LocalHTMLFilePath = FPaths::ProjectContentDir() + FILE_NETWORK_ERROR;
		UE_LOG(LogHeroUsdk, Error, TEXT("LaunchLocalErrorPage,%s"),*LocalHTMLFilePath);
		FString ConfigContent;
		if (!FFileHelper::LoadFileToString(ConfigContent, *LocalHTMLFilePath))
			return;
		UWebBrowser_0->LoadString(ConfigContent, FString(FILE_NETWORK_ERROR)+"?lang="+HeroUsdkSupportPcDelegate::GetInstance()->GetCurrentLanguage());

	}
	else
	{
		JumpToRemoteUrl();
	}
}