#include "Setting/UsdkSettings.h"

#include "HeroUSDKCustomization.h"

#if WITH_EDITOR

void UUsdkSettings::PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent)
{
	UObject::PostEditChangeProperty(PropertyChangedEvent);
	
	if (PropertyChangedEvent.Property != nullptr)
	{
		FName PropertyName = PropertyChangedEvent.Property->GetFName();
        
		if (PropertyName == GET_MEMBER_NAME_CHECKED(UUsdkSettings, Channel))
		{
			auto usdkCustom = StaticCastSharedRef<FHeroUSDKCustomization>(FHeroUSDKCustomization::MakeInstance()) ;
			usdkCustom->ParseMirror();
		}
	}
}

#endif