// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "HttpModule.h"
#if WITH_EDITOR

#include "Input/Reply.h"
#include "IDetailCustomization.h"
#if WITH_EDITOR
#include "Runtime/XmlParser/Public/XmlParser.h"
#endif

class IDetailLayoutBuilder;

class FHeroUSDKCustomization : public IDetailCustomization
{
    
public:
    /** Makes a new instance of this detail layout class for a specific detail view requesting it */
    static TSharedRef<IDetailCustomization> MakeInstance();
    
    void ParseMirror();

    // IDetailCustomization interface
    virtual void CustomizeDetails(IDetailLayoutBuilder& DetailLayout) override;
    // End of IDetailCustomization interface
    
    //保存Android配置文件参数
    static void GenAndroidCfgFile(const FString& Config);
    
    static FReply RequestConfig();
    static void OnRequestComplete(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bSuccess);

    virtual void CustomizeDetails( const TSharedPtr<IDetailLayoutBuilder>& DetailBuilder ) override;
    TSharedRef<SWidget> OnGenerateComboWidget(TSharedPtr<FString> InComboString);
    void OnSelectionChanged(TSharedPtr<FString> InSelectedItem, ESelectInfo::Type SelectInfo);

    TSharedPtr<FString> GetCurrentlySelectedItem();
    FText GetComboBoxSelectedOptionText() const;

private:
    TSharedPtr<class SComboBox< TSharedPtr<FString> > > ComboBox;
    TArray<TSharedPtr<FString>> MirrorChannels;
    TWeakPtr<IDetailLayoutBuilder> weakLayout;
 
};

#endif
