// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "Modules/ModuleManager.h"

class FHeroUSDKPluginModule : public IModuleInterface
{
public:

	/** IModuleInterface implementation */
	virtual void StartupModule() override;
	virtual void ShutdownModule() override;
    
    static inline FHeroUSDKPluginModule& Get()
    {
        return FModuleManager::LoadModuleChecked<FHeroUSDKPluginModule>("HeroUSDKPlugin") ;
    }
    
    static inline bool IsAvailable()
    {
        return FModuleManager::Get().IsModuleLoaded("HeroUSDKPlugin") ;
    }
     
    uint32 Port;
    
private:
 
    static const uint32 DEFAULT_PORT = 17323;

#if PLATFORM_WINDOWS
    void*	BiliLibraryHandle = nullptr;
#endif
};

