// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/HeroUsdkSupportData.h"


/**
 * 
 */
class HEROUSDKPLUGIN_API HeroUsdkSupportNotify
{
public:
	
	virtual ~HeroUsdkSupportNotify();
	
	/*
	* 融合SDK初始化回调
	*/
	virtual void usdk_onInitCallBack(HeroUsdkResult result, const FString& msg) = 0;

	/*
	 * 融合SDK登录回调
	 */
	virtual void usdk_onLoginCallBack(HeroUsdkResult result, const FString& userInfo, const FString& msg) = 0;

	/*
	 * 切换账号回调
	 */
	virtual void usdk_onSwitchAccountCallBack(HeroUsdkResult result, const FString& msg) = 0;

	/*
	 * 退出登录回调
	 */
	virtual void usdk_onLogoutCallBack(HeroUsdkResult result, const FString& msg) = 0;

	/*
	 * 退出回调
	 */
	virtual void usdk_onExitCallBack(HeroUsdkResult result, const FString& msg) = 0;

	/*
	 * 支付回调
	 */
	virtual void usdk_onPayCallBack(HeroUsdkResult result, const FString& paymentOrder, const FString& msg) = 0;

	/*
	 * 登录失效[防沉迷被踢下线]
	 */
	virtual void usdk_onLoginInvalid(const FString& msg) = 0;

	/*
	 * 用户已经同意协议，在这里进行init等操作
	 */
	virtual void usdk_onProtocolAgree() = 0;

	/*
	 * 获取OAID结果【Android】
	 */
	virtual void usdk_onGetOAIDResultAction(const FString& msg) = 0;

	/*
	 * 获取GAID结果【Android】
	 */
	virtual void usdk_onGetGAIDResultAction(const FString& msg) = 0;

	/*
	 * 获取AppSetID结果【Android】
	 */
	virtual void usdk_onGetAppSetIDResultAction(const FString& msg) = 0;

	/**
	 @brief 获取IDFA
	 1.获取IDFA需要添加AppTrackingTransparency.framework系统库，并且设置为Optional
	 2.在Info.plist添加NSUserTrackingUsageDescription权限描述
	 不添加，可能导致iOS 14以上无法获取IDFA
	 * @param FirstIdfa 首次安装的idfa(存入keychain)
	 * @param CurrentIdfa 当前获取的idfa，iOS14以上用户拒绝权限会返回空字符串
	 * @param Error 错误信息，有error时，idfa会返回空串
	 */
	virtual void usdk_onGetIDFAResultAction(const FString& FirstIdfa, const FString& CurrentIdfa, const FString& Error) = 0;

	/**
	 @brief 获取IDFV
	 * @param FirstIdfv 首次安装的idfv(存入keychain)
	 * @param CurrentIdfv 当前获取的idfv
	 * @param Error 错误信息，有error时，idfa会返回空串
	 */
	virtual void usdk_onGetIDFVResultAction(const FString& FirstIdfv, const FString& CurrentIdfv, const FString& Error) = 0;

	
	/*
	 * 网页账号注销结果回调
	 */
	virtual void usdk_onAccountCancellation(HeroUsdkResult result, const FString& msg) = 0 ;
	
	/*
	 * 撤销注销账号回调
	 */
	virtual void usdk_onAccountUnCancellation(HeroUsdkResult result, const FString& msg) = 0;

	/*
	 * 打开浏览器回调
	 */
	virtual void usdk_onOpenBrowerResult(HeroUsdkResult result, const FString& msg) = 0 ;

	/*
	 * 获取Google订单回调
	 */
	virtual void usdk_onGetGoogleSkuDetailsList(const FString& JSONContent) = 0;

	/*
	 * 获取USDK埋点回调内容
	 */
	virtual void usdk_onTrackDataCallBack(const FString& JSONContent) = 0 ;

	/*
	 * 获取全球账号绑定状态
	 */
	virtual void usdk_onGetGlobalBindState(HeroUsdkResult result,const FString& JSONContent,const FString& msg) = 0 ;

	/*
	 * 全球账号绑定回调
	 */
	virtual void usdk_onBindAccountWithType(HeroUsdkResult result, const FString& data, const FString& msg) = 0;

	/*
	 * 分享回调
	 */
	virtual void usdk_onShareCallBack(HeroUsdkResult result,SharePlatform sharePlatform, const FString& msg) = 0;

	/*
	 * AppsflyerUrl回调
	 */
	virtual void usdk_onGetAppsflyerUrlCallBack(HeroUsdkResult result,const FString& url, const FString& msg) = 0; 
	
	/*
	 * 截屏回调
	 */
	virtual void usdk_onScreenShotCallBack(const FString& ImagePath) = 0 ;
};
