// Fill out your copyright notice in the Description page of Project Settings.


#include "UsdkTraceOutputFile.h"
#include "Misc/App.h"
#include "../../Output/Local/UsdkOutputDeviceFile.h"

UsdkTraceOutputFile::UsdkTraceOutputFile()
{
	FString FileName =FString::Printf(TEXT("%s_USDK.log"),FApp::GetProjectName());
	const FString UsdkLogPath =FPaths::Combine(FPaths::ProjectSavedDir(),TEXT("Hero"),TEXT("Usdk"),TEXT("Logs"),FileName);
	OutputDeviceFile = MakeUnique<FUsdkOutputDeviceFile>(*UsdkLogPath);
}

UsdkTraceOutputFile::~UsdkTraceOutputFile()
{
	OutputDeviceFile.Reset();
}

void UsdkTraceOutputFile::Log(const FName& Category, ELogVerbosity::Type Verbosity, const FString& Data)
{
	OutputDeviceFile->Log(Category,Verbosity,Data);
}
