// Fill out your copyright notice in the Description page of Project Settings.


#include "UsdkTrace.h"


void UsdkTrace::AddOutput(const TSharedPtr<IUsdkTraceOutput>& Output)
{
	OutputArray.Add(Output);
}

void UsdkTrace::SetTraceLevel(ELogVerbosity::Type Level)
{
	LogLevel = Level;
}

void UsdkTrace::Log(const FName& Category, ELogVerbosity::Type Verbosity, const FString& Data)
{
	if(Verbosity<= LogLevel )
	{
		for (const auto& OutPut : OutputArray)
		{
			OutPut->Log(Category,Verbosity,Data);
		}
	}
}
