// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Log/Interface/IUsdkTrace.h"

/**
 * 
 */
class HEROUSDKPLUGIN_API UsdkTrace : public IUsdkTrace
{
public:
 virtual void AddOutput(const TSharedPtr<IUsdkTraceOutput>& Output) override;
 virtual void SetTraceLevel(ELogVerbosity::Type Level) override;
 virtual void Log(const FName& Category, ELogVerbosity::Type Verbosity, const FString& Data) override;

private:
  TArray<TSharedPtr<IUsdkTraceOutput>> OutputArray;
  ELogVerbosity::Type LogLevel = ELogVerbosity::All;
};
