// Fill out your copyright notice in the Description page of Project Settings.


#include "Log/UsdkLogSingleton.h"

#include "Log/Entity/UsdkTrace.h"
#include "Log/Entity/Local/UsdkTraceOutputFile.h"


#define GROWABLE_LOGF(SerializeFunc) \
int32	BufferSize	= 1024; \
TCHAR*	Buffer		= NULL; \
int32	Result		= -1; \
/* allocate some stack space to use on the first pass, which matches most strings */ \
TCHAR	StackBuffer[512]; \
TCHAR*	AllocatedBuffer = NULL; \
\
/* first, try using the stack buffer */ \
Buffer = StackBuffer; \
GET_VARARGS_RESULT( Buffer, UE_ARRAY_COUNT(StackBuffer), UE_ARRAY_COUNT(StackBuffer) - 1, Fmt, Fmt, Result ); \
\
/* if that fails, then use heap allocation to make enough space */ \
while(Result == -1) \
{ \
FMemory::SystemFree(AllocatedBuffer); \
/* We need to use malloc here directly as GMalloc might not be safe. */ \
Buffer = AllocatedBuffer = (TCHAR*) FMemory::SystemMalloc( BufferSize * sizeof(TCHAR) ); \
if (Buffer == NULL) \
{ \
return; \
} \
GET_VARARGS_RESULT( Buffer, BufferSize, BufferSize-1, Fmt, Fmt, Result ); \
BufferSize *= 2; \
}; \
Buffer[Result] = 0; \
; \
\
SerializeFunc; \
FMemory::SystemFree(AllocatedBuffer);

FUsdkLogSingleton::FUsdkLogSingleton()
{
	LogTracer = MakeShareable(new UsdkTrace);
	LogTracer->SetTraceLevel(ELogVerbosity::All);
	LogTracer->AddOutput(MakeShareable(new UsdkTraceOutputFile));
}

FUsdkLogSingleton& FUsdkLogSingleton::GetInst()
{
	static FUsdkLogSingleton Singleton;
	return Singleton;
}

void FUsdkLogSingleton::LogfImpl( const FName& Category,
                                 ELogVerbosity::Type Verbosity, const TCHAR* Fmt, ...) const
{
	GROWABLE_LOGF(LogTracer->Log(Category, Verbosity, Buffer))
}
