﻿// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once

#include "CoreTypes.h" 
#include "CoreMinimal.h"
#include "UsdkLogSingleton.h"
#include "Logging/LogMacros.h"
#include "Setting/UsdkLogSettings.h"



#define USDK_LOG(CategoryName, Verbosity, Format, ...) \
{ \
	if(UUsdkLogSettings::Get() && UUsdkLogSettings::Get()->bUseUsdkLog)\
	{\
		static_assert(TIsArrayOrRefOfType<decltype(Format), TCHAR>::Value, "Formatting string must be a TCHAR array."); \
		static_assert((ELogVerbosity::Verbosity & ELogVerbosity::VerbosityMask) < ELogVerbosity::NumVerbosity && ELogVerbosity::Verbosity > 0, "Verbosity must be constant and in range."); \
		FUsdkLogSingleton::GetInst().Logf(#CategoryName,ELogVerbosity::Verbosity,Format, ##__VA_ARGS__); \
	}\
	if(UUsdkLogSettings::Get() && UUsdkLogSettings::Get()->bUseUeLog)\
	{\
		UE_LOG(CategoryName, Verbosity, Format, ##__VA_ARGS__) \
	}\
}
