// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "HeroUsdkSupportNotify.h"
#include "Platform/Base/PlatformManagerBase.h"


/**
 * @brief SDK单例
 */
class HEROUSDKPLUGIN_API HeroUsdkSupportKit
{
	HeroUsdkSupportKit() = default;
public:
	HeroUsdkSupportNotify* NotifyObject;

	static auto GetInstance() -> HeroUsdkSupportKit&;
	
	void Register(UHeroUsdkSubsystem* InSubsystem);
	void Unregister();

#if UE_EDITOR
	void GenInitConfig(const FString& Config);
#endif
	UHeroUsdkSubsystem* Subsystem = nullptr;
	
	/*
	 *  ============================== 融合SDK登录、支付 ===========================
	 */

	/*
	 * 设置回调
	 */
	void SetNotify(HeroUsdkSupportNotify* Notify);

	/*
	 * 融合SDK初始化
	 */
	void init();

	/*
	 * 融合SDK登录
	 */
	void login();

	/*
	 * 进入游戏
	 */
	void enterGame(FHeroHDCGameRoleInfo roleInfo);

	/*
	 * 角色注册
	 */
	void createNewRole(FHeroHDCGameRoleInfo roleInfo);

	/*
	 * 角色升级
	 */
	void roleLevelUp(FHeroHDCGameRoleInfo roleInfo);

	/*
	 * 注销、退出登录
	 */
	void logout();

	/*
	 * 支付
	 */
	void pay(FHeroUPaymentParameters paymentParametersData, FHeroHDCGameRoleInfo roleInfo);

	/*
	 * 扫描(登录在PC端登录,SDK需要登录状态）
	 */
	void showScanViewWithExt(FString exit);

	/*
	 * 收到踢下线结果回调SDK
	 */
	void cpKickOffCallBackWithResult(FString result);

	/*
	 * 获取协议内容
	 */
	FString getProtocolResult();

	/*
	 * 点击同意通知
	 */
	void setAgreeProtocol();

	/*
	 * 打开用户中心
	 */
	void showAccountCenter() ;
	
	/*
	 * 注销账号 
	 */
	void accountCancellation();

	/*
	 * 撤回注销账号
	 */
	void accountUnCancellation();

	/*
	 * 上报问题 
	 */
	void uploadIssue();

	// 修改SDK语言
	void SetUsdkLanguage(EHeroUsdkLanguageFlag Language);
	/*
	 * 打开内置浏览器
	 * </summary>
	 * <param name="openID">中台配置URL地址的ID</param>
	 */
	void openBrowser(FString openID) ;

	void OpenSurvey(const FString& WebId);

	void OpenService();
	/*
	 * 全球无界面切换账号
	 */
	void switchAccount();

	/*
	 * 调用 track 接口，追踪一个带有属性的 event
	 */
	void trackWithProperties(FString event,TMap<FString, FString> propertys);

	/*
	 * 获取USDK内部埋点事件
	 */
	void trackEventDataCallback();
	
	/*
	 * 打开Xsolla商城支付
	 */
	void startXsollaPayWithXsollaProperties(TMap<FString, FString> propertys);

	/*
	 * 获取全球渠道账户绑定的状态
	 */
	void getGlobalBindState();
	
	/*
	 * 分享
	 */
	void share(FShareInfo ShareInfo);

	/*
	 * 保存图片到相册
	 */
	void addPicToAlbum(FString imagePath,FString albumName) ;

	/*
	 * 应用跳转
	 */
	void jumpToApp(FString url) ;
	
	/*
	 * 获取UE4插件版本号
	 */
	FString getHeroUsdkUE4Version();

	/*
	 * 渠道ID
	 */
	int getChannelId();
	
	int getMirrorChannelId();

	/*
	 * 渠道名称
	 */
	FString getChannelName();

	/*
	 * 获取渠道SDK的版本名
	 */
	FString getChannelSdkVersionName();
	
	/*
	 * 获取英雄官网渠道的ProjectId，常用于游戏需要CPS分包时
	 */
	FString getProjectId();

	/*
	 * =================== 市场插件相关API ===================
	 */

	/*
	 * 市场插件日志上报
	 */
	void logEvent(FString eventName,TMap<FString, FString> propertys) ;

	/*
	 * 市场插件支付日志上报
	 */
	void logPurchaseWithOrderId(FString orderId,double amount,FString currency,TMap<FString, FString> propertys) ;
	
	/*
	 *  ============================== iOS ===========================
	 */

	/*
	 * 获取登录用户名
	 */
	FString getUserName();

	/*
	 * 获取登录用户ID
	 */
	FString getUserId();

	/*
	 * 获取ID（部分游戏使用@"id"字段作为唯一标示符）
	 */
	FString getSdkId();

	/*
	 * 获取设备号(优先取的IDFA、没取到则取的UUID)
	 */
	FString getDeviceNum();
	
	/*
	 * 获取广告标识符IDFA (iOS Only)
	 */
	void getIDFA();

	/*
	 * 获取广告标识符IDFV (iOS Only)
	 */
	void getIDFV();

	/*
	 * iOS【注销、退出登陆并显示账号历史界面】
	 */
	void logoutAndSowLoginView();

	/*
	 * 上报闪屏
	 */
	void postSplashScreenEndSuccess();

	/*
	 *  ============================== Android ===========================
	 */

	/*
	 * 判断当前渠道在调用退出接口时是否会弹出退出框
	 */
	bool isChannelHasExitDialog();

	/*
	 * 获取用户在HeroUSDK后台配置的自定义参数值。
	 */
	FString getCustomParams(FString key);

	/*
	 * 调用渠道的扩展方法(如显示/隐藏悬浮框，防沉迷查询，进入用户中心等)。
	 */
	bool callExtendApi(int extendType);

	/*
	 * 获取当前设备的OAID值
	 */
	void getOAID();

	/*
	 * 获取硬核渠道信息（Android）
	 */
	FString getChannelMsg();
	/*
	 * 获取当前设备的GAID值
	 */
	void GetGAID();

	/*
	 * 获取当前设备的AppSetID值
	 */
	void GetAppSetID();

	/*
	 * android【退出】
	 */
	void exit();

	/*
	* 获取订单详情列表
	* <f1>如果接入usdk通过中台出全球渠道包，商品id需要传入中台配置的usdk商品id</f1>
	*/
	void getGoogleSkuDetailsList(TArray<FString> gameGoodsList);

	/*
	 * 屏蔽市场插件SDK默认埋点[Android]
	 */
	void setDisableMarketEvent(TMap<MARKET_EVENT,bool> bundle);

	/*
	 * 获取邀请链接
	 */
	void getAppsflyerOneLinkUrl(const TMap<FString,FString>& bundle) ;

	/*
	 * 获取链接跳转参数
	 */
	FString getAppsflyerOneLinkData();

	/*
	 * 获取appsflyer 唯一标识
	 */
	FString getAppsflyerUID();

	/*
	 * Google积分墙
	 */
	void reportAccountInfo(FString serverId,FString serverName,FString roleId,FString roleName,FString cpExt);
	
private:
	/*
	 * 初始化标记
	 */
	bool bIsAlive = false;

	
	

	/*
	 * 根据key获取value
	 */
	FString getChanelValueByKey(FString key,const TSharedPtr<FJsonObject> JsonObject);

public:
	
	//FHeroUProject uProject;

	FString GetProductId() const
	{
		return ProductId;
	}

	
	FString GetProductKey() const
	{
		return ProductKey;
	}

private:
	TUniquePtr<FPlatformManagerBase> PlatformManager;
	FString    ProductId;                     //产品ID
	FString    ProductKey;                    //产品key
};
