#pragma once
#include "HeroUsdkSupportNotify.h"
#include "Data/HeroUsdkLanguageFlag.h"

class UHeroUsdkSubsystem;



class FPlatformManagerBase
{
public:
	FPlatformManagerBase(UHeroUsdkSubsystem* InSubsystem):Subsystem(InSubsystem)
	{
	}
	virtual ~FPlatformManagerBase() = default;
	virtual void SetNotify() = 0;
	virtual void Init() = 0;
	virtual void Login() = 0;
	virtual void EnterGame(FHeroHDCGameRoleInfo roleInfo) = 0;
	virtual void CreateNewRole(FHeroHDCGameRoleInfo roleInfo) = 0;
	virtual void RoleLevelUp(FHeroHDCGameRoleInfo roleInfo) = 0;
	virtual  void logout() = 0;
	virtual  void Pay(FHeroUPaymentParameters paymentParametersData, FHeroHDCGameRoleInfo roleInfo) = 0;
	virtual void showScanViewWithExt(FString exit) = 0;
	virtual void cpKickOffCallBackWithResult(FString result) = 0;
	virtual FString getProtocolResult() = 0;
	virtual void setAgreeProtocol() = 0;
	virtual void showAccountCenter() = 0 ;
	virtual void accountCancellation() =0;
	virtual void accountUnCancellation() = 0;
	virtual void uploadIssue() = 0;
	virtual void SetUsdkLanguage(EHeroUsdkLanguageFlag Language) = 0;
	virtual void openBrowser(FString openID) = 0;
	virtual void OpenSurvey(const FString& WebId) = 0;
	virtual void OpenService() = 0;
	virtual void switchAccount() = 0;
	virtual void trackWithProperties(FString event,TMap<FString, FString> propertys) =0;
	virtual void trackEventDataCallback()=0;
	virtual void startXsollaPayWithXsollaProperties(TMap<FString, FString> propertys)=0;
	virtual void getGlobalBindState() = 0;
	virtual void share(FShareInfo shareInfo)=0;
	virtual void addPicToAlbum(FString imagePath,FString albumName) =0;
	virtual void jumpToApp(FString url) =0;
	virtual int getChannelId() =0;
	virtual int getMirrorChannelId()=0;
	virtual  FString getChannelName()=0;
	virtual FString getChannelSdkVersionName() =0;
	virtual FString getProjectId()=0;
	virtual void logEvent(FString eventName,TMap<FString, FString> propertys) =0;
	virtual void logPurchaseWithOrderId(FString orderId,double amount,FString currency,TMap<FString, FString> propertys) =0;
	virtual FString getUserName() =0;
	virtual FString getUserId() = 0;
	virtual FString getSdkId() =0;
	virtual FString getDeviceNum()=0;
	virtual void getIDFA()=0;
	virtual void getIDFV()=0;
	virtual void logoutAndSowLoginView()=0;
	virtual void postSplashScreenEndSuccess()=0;
	virtual bool isChannelHasExitDialog() =0;
	virtual FString getCustomParams(FString key)=0;
	virtual bool callExtendApi(int extendType)=0;
	virtual void getOAID()=0;
	virtual FString getChannelMsg()=0;
	virtual void GetGAID()=0;
	virtual void GetAppSetID()=0;
	virtual void exit()=0;
	virtual void getGoogleSkuDetailsList(TArray<FString> gameGoodsList)=0;
	virtual void setDisableMarketEvent(TMap<MARKET_EVENT,bool> bundle)=0;
	virtual void getAppsflyerOneLinkUrl(const TMap<FString,FString>& bundle) =0;
	virtual FString getAppsflyerOneLinkData()=0;
	virtual FString getAppsflyerUID()=0;
	virtual void reportAccountInfo(FString serverId,FString serverName,FString roleId,FString roleName,FString cpExt)=0;
protected:
	FString checkPostParamster(TMap<FString, FString> parameters);
	UHeroUsdkSubsystem* Subsystem;
};

