// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "BiliPayInfo.generated.h"

/**
 * 
 */

/*
 * SDK内购参数
 */
USTRUCT(BlueprintType)
struct FBiliPayInfo
{
    GENERATED_BODY()
    
public:
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString    appKey;       
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    orderSign;                       
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    zoneId;                   //游戏区服id

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString    tradeNum;                   //购买商品时端游研发方产生的订单号，不超过50字符（若单机游戏不存在订单号，可随机生成一段字符串）

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString    game_money;                   //游戏内的道具数量，最大值“99999999” （九千九百九十万零九千九百九十九）
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString    product_name;                   //商品名称，不超过100字符，如果是游戏货币类道具必须包含本次购买数量，例如：钻石200个。不能包含特殊字符%#&=?
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString    money;                   //商品价格，校验支付防沉迷,单位：分。最大值” 100000000”100万元
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString    notify_url;                   //自定义支付回调地址，优先级高于在平台配置的回调地址，不超过128个字符。不支持如下带参格式，示例：http://host/notify?a=xxx&b=xxx
	
	FString ToString();
};

