// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UObject/NoExportTypes.h"
#include "HeroUsdkSupportData.generated.h"

/**
 * 
 */

UCLASS()
class HEROUSDKPLUGIN_API UHeroUsdkSupportData : public UObject
{
    GENERATED_BODY()
};

UENUM(BlueprintType)
enum HeroUsdkResult {
    HeroUsdkSuccess = 0, //成功
    HeroUsdkFailed = -1, //失败
    HeroUsdkCancel = -2, //取消
};

enum HeroUSDKBindType
{
	HeroUSDKBindTypeFacebook = 1 , //facebook
	HeroUSDKBindTypeGoogle = 2 , //google
	HeroUSDKBindTypeGameCenter = 3, //GameCenter
	HeroUSDKBindTypeWeChat = 4, //WeChat
	HeroUSDKBindTypeTwitter = 5, //Twitter
	HeroUSDKBindTypeApple = 7, //Apple
	HeroUSDKBindTypeLine = 8, //Line
	HeroUSDKBindTypeGameWith = 12, //GameWith
};

 enum MARKET_EVENT
{
	MARKET_ALL,                 //除激活以外全部屏蔽
	MARKET_REGISTER_SUCCESS,    //屏蔽注册
	MARKET_LOGIN_SUCCESS,       //屏蔽登录成功
	MARKET_LOGIN_FAILED,        //屏蔽登录失败
	MARKET_LOGIN_CANCEL,        //屏蔽取消登录
	MARKET_LOGOUT_SUCCESS,      //屏蔽注销
	MARKET_PAY_SUCCESS,         //屏蔽支付成功
	MARKET_PAY_FAILED,          //屏蔽支付失败
	MARKET_PAY_CANCEL,          //屏蔽取消支付
	MARKET_BEFORE_PAY           //屏蔽下单前
};


/*
 * SDK内购参数
 */
USTRUCT(BlueprintType)
struct FHeroUPaymentParameters
{
    GENERATED_BODY()
    
public:
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    goodsId;                        //商品ID
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    extraParams;                   //拓展信息
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    cpOrder;                       //游戏订单ID
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    callbackUrl;                   //支付回调地址

	TMap<FString,FString> ParseToMap() const;
    
};


/*
 * SDK内购订单数据
 */
USTRUCT(BlueprintType)
struct FHeroUPaymentOrder
{
    GENERATED_BODY()
    
public:
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    plat;                          //平台，iOS、Android
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    sdkOrderId;                    //sdkOrderId
    
    /*
     * iOS
     */
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    orderAmount;                   //orderAmount
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    currency;                      //currency
    
    /*
     * Android
     */
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    cpOrderId;                     //cpOrderId
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    extraParams;                   //extraParams
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString    errorMsg;                     //errorMsg
    
};


/*
 * 角色参数
 */
USTRUCT(BlueprintType)
struct FHeroHDCGameRoleInfo
{
    GENERATED_BODY()
    
public:
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString channelUserId;      //渠道用户ID(玩家登录账号)(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString gameUserId;         //游戏生成的账号ID(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString serverId;           //服务器ID(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString serverName;         //服务器名称(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString roleId;             //角色ID(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString roleName;           //角色昵称(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString roleAvatar;         //角色头像地址(非必传参数)

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString level ;             //角色等级(非必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString vipLevel ;          //角色VIP等级(非必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString gold1 ;             //角色一级货币，比如点卷(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString gold2 ;             //角色二级货币，比如钻石(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString sumPay ;            //角色总共充值金额(必传参数)
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString levelExp ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString vipScore ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString rankLevel ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString rankExp ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString rankLeve2 ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString rankExp2 ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString cupCount1 ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString cupCount2 ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString totalKill ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString totalHead ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString avgKD ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString maxKD ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString maxCK ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString mainWeaponId ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString viceWeaponId ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString medalCount ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString teamId ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString teamName ;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    bool floatHidden = false;

    //android
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString partyName;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString roleCreateTime;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    int balanceLevelOne = -1;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    int balanceLevelTwo = -1;

    //android 360渠道独有
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString partyId;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString roleGender;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString rolePower;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString partyRoleId;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString partyRoleName;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString professionId;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString profession;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString friendList;

	TMap<FString,FString> ParseToMap() const;
};


/*
 * 用户信息，登录回调中使用
 */
USTRUCT(BlueprintType)
struct FUserInfo
{
    GENERATED_BODY()
    
public:
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString plat ;                   //平台 iOS、Android
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString accessToken ;            //accessToken
        
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString sdkUserId ;              //sdkuserid
        
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString userName ;               //username
    
    /*
     * iOS回调
     */
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString accessCode ;             //accessCode
    
    /*
     * Android回调
     */
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString channelToken ;           //channelToken
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString extendParams ;           //extendParams
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    bool isFristLogin = false;           //isFristLogin
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString serverMessage ;          //serverMessage

};

UENUM()
enum class SharePlatform : int32
{
	None,
	HeroUSDKSharePlatformQQ = 20001, //QQ分享
	HeroUSDKSharePlatformQZone = 20002, //QQ空间分享
	HeroUSDKSharePlatformWeChat = 20003, //微信分享
	HeroUSDKSharePlatformWeChatMements = 20004, //微信朋友圈分享
	HeroUSDKSharePlatformSina = 20005, //新浪分享
	HeroUSDKSharePlatformDouyin_Contact=20006,//抖音好友
	HeroUSDKSharePlatformDouyin_Moment=20007,//抖音编辑/发布界面
	HeroUSDKSharePlatformXHS=20008,//小红书
	HeroUSDKSharePlatform_KuaiShou=20009,//快手
	HeroUSDKSharePlatformB_Dynamic=20010,//b站动态
	HeroUSDKSharePlatformMYS_D=20011,//皎皎角（二重螺旋官方自研平台）摸鱼设动态
	HeroUSDKSharePlatformTapTap=20012,//taptap
	HeroUSDKSharePlatformDouyin_DIARY=20013,//分享抖音日常
	HeroUSDKSharePlatformMYS_T=20014,//皎皎角（二重螺旋官方自研平台）摸鱼设文章
	HeroUSDKSharePlatformAll = 20000, //有界面分享
	HeroUSDKSharePlatformTwitter = 30001, //Facebook无界面分享
	HeroUSDKSharePlatformFaceBook = 30002, //Facebook无界面分享
	//以下仅试用于Android平台
	HeroUSDKSharePlatformTwitterFriends = 30003, //分享文本到Twitter朋友，无界面分享
	HeroUSDKSharePlatformTweets = 30004, //发文本推文，无界面分享
	HeroUSDKSharePlatformINSTAGRAM=30005,//Istagram
	HeroUSDKSharePlatformTIKTOK=30006,//Tiktok
	HeroUSDKSharePlatformTIKTOK_MOMENT=30007,//Tiktok朋友圈
	HeroUSDKSharePlatformLOUNGE=30008,//LOUNGE(韩国专属)
	HeroUSDKSharePlatformLUNOLOFT=30009,//Lunoloft（二重螺旋官方自研平台）
	HeroUSDKSharePlatformKAKAO=30010,//Kakao
	HeroUSDKSharePlatformDISCORD=30011,//DISCORD
};

UENUM()
enum class ShareType : int32
{
	None,
	HeroUSDKShareTypeLink = 1 ,//分享链接
	HeroUSDKShareTypeImage = 2 ,//分享图片
	HeroUSDKShareTypeText = 3 ,//分享文本
};

/*
 * 分享
 */
USTRUCT(BlueprintType)
struct FShareInfo
{
    GENERATED_BODY()
    
public:
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    SharePlatform sharePlatform = SharePlatform::None;          //分享平台
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    ShareType shareType = ShareType::None;                  //分享类型
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString title ;							//分享标题
	
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString text ;							//分享内容
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString linkUrl ;							//分享链接
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
    FString imagePath ;						//分享图片路径

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString linkImagePath ;						//分享图片路径
};

/*
 * 回调字段说明
 */
USTRUCT(BlueprintType)
struct FGlobalOrderInfo
{
	GENERATED_BODY()
    
public:
    
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString gameGoodsId ;                  //游戏商品id
    
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString price ;                //当地价格
    
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString googleGoodsId ;                //谷歌后台商品id
    
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="PCSDK")
	FString currency ;                  //当地币种
	
};
