// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UsdkBaseWidget.h"

#include "Blueprint/UserWidget.h"
#include "Setting/UsdkSettings.h"

#include "PC_LoginPannel.generated.h"

/**
 * 
 */
UCLASS()
class HEROUSDKPLUGIN_API UPC_LoginPannel : public UUsdkBaseWidget
{
	GENERATED_BODY()
public:
	void JumpToTapTapUrl();
protected:
	virtual void NativeConstruct() override;
	virtual void NativeTick(const FGeometry& MyGeometry, float InDeltaTime) override;
public:
	virtual void HandleJSCallBack(FString data) override;
protected:
	virtual void OnWebClose (FString data) override;
	virtual void OnCloseClickedImp() override;

	virtual void OnLoadCompletedImp() override;
	void OnPopPannel();
	virtual FString GetLocalUrl() override;
	virtual FString GetRemoteUrl() override;

	
	void GenerateFacebookInjectMap();
protected:
	int32 AntiAddictionTime = -1;
	FString msg;
	UUsdkSettings* Setting;
	TMap<FString, FString> FacebookInjectMap;
};
