// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UsdkBaseWidget.h"
#include "Data/PayOrderResult.h"
#include "Data/HeroUsdkSupportData.h"
#include "PC_PayPannel.generated.h"



/**
 * 
 */
UCLASS()
class UPC_PayPannel : public UUsdkBaseWidget
{
	GENERATED_BODY()

public:
	virtual  void OnLoadCompletedImp() override;

	virtual  void OnBeforeNavigationImp(const FString& Url) override;

	void SetPayParam(const FHeroUPaymentParameters& paymentParametersData, const FPayOrderResult& PayOrder)
	{
		PaymentParameters = paymentParametersData;
		PayOrderResult =PayOrder;
	}
	FString GetOfficePayUrl(FString BaseUrl);

	//获取Xsolla支付地址
	FString GetXsollaPayUrl(FString BaseUrl);
	

	virtual void HandleJSCallBack(FString data) override;
	
	void HandleXsollaCallBack(const FString& data) ;
	
	virtual void OnCloseClickedImp() override;

protected:
	virtual FString GetLocalUrl() override;
	virtual FString GetRemoteUrl() override;

private:
	FHeroUPaymentParameters PaymentParameters;
	FPayOrderResult PayOrderResult;
};
