#pragma once

#include "UsdkBaseWidget.h"
#include "Blueprint/UserWidget.h"
#include "PC_SurveyPanel.generated.h"


UCLASS()
class HEROUSDKPLUGIN_API UPC_SurveyPanel : public UUsdkBaseWidget
{
	GENERATED_BODY()
	
public:
	virtual void Start() override;
	
	virtual FString GetUrl() override;
	virtual void HandleJSCallBack(FString data);

	UFUNCTION()
	void HandleBackClicked();
	UFUNCTION()
	void HandleForwardClicked();
	UFUNCTION()
	void HandleRefreshClicked();

	virtual  void OnLoadCompletedImp() override;
	
	void SetUrl(const FString& InUrl)
	{
		Url = InUrl;
	}
	virtual void OnCloseClickedImp() override;
	virtual void JumpToRemoteUrl() override{}
public:
	UPROPERTY(BlueprintReadOnly, Category="PCSDK|Survey")
	FString Url;
	UPROPERTY(meta = (BindWidget))
	UButton* Button_Back;
	UPROPERTY(meta = (BindWidget))
	UButton* Button_Forward;
	UPROPERTY(meta = (BindWidget))
	UButton* Button_Refresh;
	bool isFirstTime =false;
	bool bIsCancelAccountSuccess = false;
};