// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "Components/Button.h"
#include "UWebBrowser.h"
#include "UsdkBaseWidget.generated.h"

/**
 * 
 */
UCLASS(Abstract)
class HEROUSDKPLUGIN_API UUsdkBaseWidget : public UUserWidget
{
	GENERATED_BODY()
public:
	virtual void NativeConstruct() override;

	virtual void Start();

	virtual void NativeTick(const FGeometry& MyGeometry, float InDeltaTime) override;

	

	UFUNCTION()
	void OnCloseClicked();
	
	UFUNCTION()
	void OnUrlChanged(const FText& Text);
	UFUNCTION()
	void OnBeforePopup(FString URL, FString Frame);
	UFUNCTION()
	void OnLoadCompleted();
	UFUNCTION()
	void OnBeforeNavigation(const FString& Url);

	UFUNCTION()
	void invokeUE(FString data);
	static FString GetUeDataInteral(const FString& Key);

	UFUNCTION()
	FString getUeData(const FString& Key);
	static void SetUeDataInteral(const FString& Key, const FString& Value);

	UFUNCTION()
	bool setUeData(const FString& Key, const FString& Value);
	
	UFUNCTION()
	void close(FString data);

	virtual void OnWebClose (FString data);

	UFUNCTION()
	void launchURL(const FString& URL);
	void JumpURL(const FString& URL);

	UFUNCTION()
	void HandleWebPageLoadTimeout();

	virtual FString GetUrl();
	virtual void HandleJSCallBack(FString data) {}
	virtual  void OnBeforeNavigationImp(const FString& Url){}
	virtual  void OnLoadCompletedImp();
	virtual void OnCloseClickedImp();
	virtual void JumpToRemoteUrl();

	UFUNCTION()
	void LaunchLocalErrorPage();

	UFUNCTION()
	void HandleOnLoadStarted();
protected:
	virtual FString GetLocalUrl(){ return {};}
	virtual FString GetRemoteUrl(){ return {};}
	
	UPROPERTY(meta = (BindWidget))
	UButton* Button_Close;

	UPROPERTY(meta = (BindWidget))
	UUWebBrowser* UWebBrowser_0;

	bool bCanCountDown = false;
	float CloseBtnShowTime = 0.f;

	static TMap<FString, FString> FilledMap;

	float LoadDuration = 0;
	bool IsCounting = false;
	
	static bool IsRemoteUrl;
private:
	FTimerHandle WebPageLoadTimerHandle;
};
