// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Engine/DeveloperSettings.h"
#include "UsdkLogSettings.generated.h"

/**
 * 
 */
UCLASS(config = UsdkLogSettings, defaultconfig)
class HEROUSDKPLUGIN_API UUsdkLogSettings : public UDeveloperSettings
{
	GENERATED_BODY()
public:
	virtual FName GetContainerName() const override
	{
		return "Project";
	}

	virtual FName GetCategoryName() const override
	{
		return "Hero";
	}
#if WITH_EDITOR	
	virtual FText GetSectionText() const override
	{
		return FText::FromString(TEXT("USDK日志设置"));
	}
	
	virtual FText GetSectionDescription() const override
	{
		return FText::FromString(TEXT("USDK日志设置"));
	}
#endif
	static UUsdkLogSettings* Get() { return GetMutableDefault<UUsdkLogSettings>(); }
	
	UPROPERTY(Config,EditAnywhere, Category = Log)
	bool bUseUsdkLog = true;
	UPROPERTY(Config,EditAnywhere, Category = Log)
	bool bUseUeLog = true;
};
