

#pragma once
#include "UsdkSettingsTypes.h"
#include "Policies/CondensedJsonPrintPolicy.h"
#include "Serialization/JsonReader.h"
#include "Serialization/JsonSerializer.h"
#include "UsdkSettings.generated.h"

UCLASS(config = Game, defaultconfig, notplaceable)
class HEROUSDKPLUGIN_API UUsdkSettings : public UObject
{
	GENERATED_BODY()

public:
#if WITH_EDITOR
	virtual  void PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent) override;
#endif
	UPROPERTY(Config, EditAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "中台参数"))
	FString PlatformAccessUrl ;
		
    UPROPERTY(Config,VisibleAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "渠道参数 (中台)"))
    FString UsdkConfig ;

	UPROPERTY(Config,VisibleAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "国内初始化参数"))
	FString ChinaInitConfig;

	UPROPERTY(Config,VisibleAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "海外初始化参数"))
	FString GlobalInitConfig;

	UPROPERTY(Config,VisibleAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "iOS国内初始化参数"))
	FString IosMainlandInitConfig;

	UPROPERTY(Config,VisibleAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "iOS海外初始化参数"))
	FString IosGlobalInitConfig;
	
	UPROPERTY(Config,VisibleAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "usdk初始化参数"))
	FString UsdkInitConfig;
	
    UPROPERTY(Config, EditAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "渠道"))
    EHeroUSDKChannel Channel = EHeroUSDKChannel::China;

	UPROPERTY(Config)
	FString MirrorConfig;

	UPROPERTY(Config)
	FString CurrMirror;

	UPROPERTY(Config, EditAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "游戏版本号（B站需填）"))
	FString GameVersion = TEXT("1");

	UPROPERTY(Config, EditAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "开启调试模式"))
	bool bIsDebug = false;
	UPROPERTY(Config, EditAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "是否是PC版署包"))
	bool bIsPublish = false;

	UPROPERTY(Config, EditAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "是否开启巨量sdk"))
	bool bIsJuLiang = false;

	UPROPERTY(Config, EditAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "是否开启抖音sdk"))
	bool bIsDouYin = false;
	
	UPROPERTY(Config, EditAnywhere, Category = "Hero USDK Settings | Hero USDK", meta = (DisplayName = "icon路径"))
	FString iconPath;
};

