// Copyright (C) 2025 Tencent. All rights reserved.

#ifndef RAIL_SDK_RAIL_DLC_DEFINE_H
#define RAIL_SDK_RAIL_DLC_DEFINE_H

#include "rail/sdk/rail_event.h"

namespace rail {
#pragma pack(push, RAIL_SDK_PACKING)

enum EnumRailDlcContentType {
    kRailDlcContentTypeFile = 1,
    kRailDlcContentTypeBuiltIn = 2,
};

struct RailDlcInfo {
    RailDlcID dlc_id;     // ID of the DLC
    RailGameID game_id;   // ID of the game
    RailString version;   // version number of the DLC
    RailString name;      // DLC's name
    RailString description;  // Description of the DLC
    double original_price;   // The original price of the DLC
    double discount_price;   // The discount price of the DLC
    EnumRailDlcContentType content_type;
    RailDlcInfo() {
        discount_price = 0.0;
        original_price = 0.0;
        content_type = kRailDlcContentTypeFile;
    }
};

struct RailDlcOwned {
    RailDlcID dlc_id;
    bool is_owned;
    
    RailDlcOwned() {
        is_owned = false;
    }
};

namespace rail_event {

struct RailCheckAllDlcsStateReadyResult : public RailEvent<kRailEventDlcCheckAllDlcsStateReadyResult> {
    RailCheckAllDlcsStateReadyResult() {
        result = kFailure;
    }
};

struct RailQueryIsOwnedDlcsResult : public RailEvent<kRailEventDlcQueryIsOwnedDlcsResult> {
    RailArray<RailDlcOwned> dlc_owned_list;

    RailQueryIsOwnedDlcsResult() {
        result = kFailure;
    }
};

struct RailDlcInstallStart : public RailEvent<kRailEventDlcInstallStartResult> {
    RailDlcID dlc_id;

    RailDlcInstallStart() {
        result = kFailure;
    }
};

struct RailDlcInstallProgress : public RailEvent<kRailEventDlcInstallProgress> {
    RailDlcID dlc_id;
    uint32_t progress;
    uint64_t finished_bytes;
    uint64_t total_bytes;
    uint32_t speed;

    RailDlcInstallProgress() {
        progress = 0;
        finished_bytes = 0;
        total_bytes = 0;
        speed = 0;
    }
};

struct RailDlcInstallFinished : public RailEvent<kRailEventDlcInstallFinished> {
    RailDlcID dlc_id;

    RailDlcInstallFinished() {
        result = kFailure;
    }
};

struct RailDlcUninstallProgress : public RailEvent<kRailEventDlcUninstallProgress> {
    RailDlcID dlc_id;
    uint32_t progress;
    uint64_t finished_files;
    uint64_t total_files;

    RailDlcUninstallProgress() {
        progress = 0;
        total_files = 0;
        finished_files = 0;
    }
};

struct RailDlcUninstallFinished : public RailEvent<kRailEventDlcUninstallFinished> {
    RailDlcID dlc_id;

    RailDlcUninstallFinished() {
        result = kFailure;
    }
};

struct RailDlcOwnershipChanged : public RailEvent<kRailEventDlcOwnershipChanged> {
    RailDlcID dlc_id;
    bool is_active;

    RailDlcOwnershipChanged() {
        is_active = true;
    }
};

struct RailDlcPauseInstall : public RailEvent<kRailEventDlcPauseInstall> {
    RailDlcID dlc_id;

    RailDlcPauseInstall() {
    }
};

struct RailDlcResumeInstall : public RailEvent<kRailEventDlcResumeInstall> {
    RailDlcID dlc_id;

    RailDlcResumeInstall() {
    }
};

struct RailDlcNeedUpdate : public RailEvent<kRailEventDlcNeedUpdate> {
    RailDlcID dlc_id;
    RailString new_version;

    RailDlcNeedUpdate() {
    }
};

struct RailShowDlcManageWindowResult: public RailEvent<kRailEventDlcShowDlcManageWindowResult> {
    RailDlcID dlc_id;
    bool is_show;

    RailShowDlcManageWindowResult() {
        is_show = false;
    }
};

struct RailVerifyDlcIntegrityResult : public RailEvent<kRailEventDlcVerifyDlcIntegrityResult> {
    RailDlcID dlc_id;

    RailVerifyDlcIntegrityResult() {
        result = kFailure;
    }
};

}  // namespace rail_event

#pragma pack(pop)
}  // namespace rail

#endif  // RAIL_SDK_RAIL_DLC_DEFINE_H
