// Copyright (C) 2025 Tencent. All rights reserved.

#ifndef RAIL_SDK_RAIL_GAME_H
#define RAIL_SDK_RAIL_GAME_H

#include "rail/sdk/rail_game_define.h"

namespace rail {
#pragma pack(push, RAIL_SDK_PACKING)

class IRailGame {
  public:
    // get current game id
    virtual RailGameID GetGameID() = 0;

    virtual RailResult ReportGameContentDamaged(EnumRailGameContentDamageFlag flag) = 0;

    // get game install path
    virtual RailResult GetGameInstallPath(RailString* app_path) = 0;

    // query game subscribe state, callback is QuerySubscribeWishPlayState
    virtual RailResult AsyncQuerySubscribeWishPlayState(const RailString& user_data) = 0;

    // deprecated
    virtual RailResult GetPlayerSelectedLanguageCode(RailString* language_code) = 0;

    // deprecated
    virtual RailResult GetGameSupportedLanguageCodes(RailArray<RailString>* language_codes) = 0;

    // deprecated
    virtual RailResult SetGameState(EnumRailGamePlayingState game_state) = 0;

    // deprecated
    virtual RailResult GetGameState(EnumRailGamePlayingState* game_state) = 0;

    // deprecated
    virtual RailResult RegisterGameDefineGamePlayingState(
                        const RailArray<RailGameDefineGamePlayingState>& game_playing_states) = 0;

    // deprecated
    virtual RailResult SetGameDefineGamePlayingState(uint32_t game_playing_state) = 0;

    // deprecated
    virtual RailResult GetGameDefineGamePlayingState(uint32_t* game_playing_state) = 0;

    virtual RailResult GetBranchBuildNumber(RailString* build_number) = 0;

    virtual RailResult GetCurrentBranchInfo(RailBranchInfo* branch_info) = 0;

    // deprecated
    virtual RailResult StartGameTimeCounting(const RailString& counting_key) = 0;

    // deprecated
    virtual RailResult EndGameTimeCounting(const RailString& counting_key) = 0;

    // deprecated
    virtual RailID GetGamePurchasePlayerRailID() = 0;

    // return the earliest game purchase time, number of seconds since Jan 1, 1970
    virtual uint32_t GetGameEarliestPurchaseTime() = 0;

    // deprecated
    virtual uint32_t GetTimeCountSinceGameActivated() = 0;

    // deprecated
    virtual uint32_t GetTimeCountSinceLastMouseMoved() = 0;

    // the maximum number of files that can be repaired at one time is 50. The game file name
    // must contain the relative path to the game installation directory.
    virtual RailResult RepairDamagedGameFiles(const RailArray<RailString>& game_files) = 0;
};

#pragma pack(pop)
}  // namespace rail

#endif  // RAIL_SDK_RAIL_GAME_H
