// Copyright (C) 2025 Tencent. All rights reserved.

#ifndef RAIL_SDK_RAIL_SCREENSHOT_H
#define RAIL_SDK_RAIL_SCREENSHOT_H

#include "rail/sdk/rail_screenshot_define.h"

namespace rail {

#pragma pack(push, RAIL_SDK_PACKING)

// deprecated. This API will be removed in the future version.
class IRailScreenshot;
class IRailScreenshotHelper {
  public:
    virtual IRailScreenshot* CreateScreenshotWithRawData(const void* rgb_data,
                                uint32_t len,
                                uint32_t width,
                                uint32_t height) = 0;

    virtual IRailScreenshot* CreateScreenshotWithLocalImage(const RailString& image_file,
                                const RailString& thumbnail_file) = 0;

    virtual void AsyncTakeScreenshot(const RailString& user_data) = 0;

    virtual void HookScreenshotHotKey(bool hook) = 0;

    virtual bool IsScreenshotHotKeyHooked() = 0;
};

// deprecated. This API will be removed in the future version.
class IRailScreenshot : public IRailComponent {
  public:
    virtual bool SetLocation(const RailString& location) = 0;

    virtual bool SetUsers(const RailArray<RailID>& users) = 0;

    virtual bool AssociatePublishedFiles(const RailArray<SpaceWorkID>& work_files) = 0;

    virtual RailResult AsyncPublishScreenshot(const RailString& work_name,
                        const RailString& user_data) = 0;
};

#pragma pack(pop)
}  // namespace rail

#endif  // RAIL_SDK_RAIL_SCREENSHOT_H
