// Copyright (C) 2025 Tencent. All rights reserved.

#ifndef RAIL_THIRD_PARTY_ACCOUNT_LOGIN_DEFINE_H
#define RAIL_THIRD_PARTY_ACCOUNT_LOGIN_DEFINE_H

#include "rail/sdk/rail_player_define.h"

namespace rail {
#pragma pack(push, RAIL_SDK_PACKING)

struct RailThirdPartyAccountInfo {
    RailThirdPartyAccountInfo() {
        error_code = 0;
        token_expire_time = 0;
        real_name_auth = false;
    }

    uint32_t error_code;
    RailString error_msg;
    RailString open_id;
    RailString token;
    uint32_t token_expire_time;  // UTC time
    RailString channel;
    RailString pf;
    RailString user_name;
    bool real_name_auth;
    RailString pf_key;
    RailString picture_url;
    RailString ext_str;
};

struct RailThirdPartyAccountLoginOptions {
    RailThirdPartyAccountLoginOptions() {
        account_type = kRailPlayerAccountUnknow;
    }

    RailPlayerAccountType account_type;
    RailString code;
};

struct RailRequestMobileAutoLoginCodeOptions {
    RailRequestMobileAutoLoginCodeOptions() {
        appid = 0;
    }

    uint32_t appid;
};

namespace rail_event {

struct RailThirdPartyAccountLoginResult
    : public RailEvent<kRailThirdPartyAccountLoginResult> {
    RailThirdPartyAccountLoginResult() {
    }

    RailThirdPartyAccountInfo account_info;
};

struct RailNotifyThirdPartyAccountQrCodeInfo
    : public RailEvent<kRailThirdPartyAccountLoginNotifyQrCodeInfo> {
    RailNotifyThirdPartyAccountQrCodeInfo() {
    }

    RailString qr_code_url;
};

struct RailRequestMobileAutoLoginCodeResult
    : public RailEvent<kRailThirdPartyAccountRequestMobileAutoLoginCodeResult> {
    RailRequestMobileAutoLoginCodeResult() {
        code_expire_time = 0;
    }

    RailString code;
    uint32_t code_expire_time;  // UTC time
};

struct RailThirdPartyAccountRefreshTokenResult
    : public RailEvent<kRailThirdPartyAccountRefreshTokenResult> {
    RailThirdPartyAccountRefreshTokenResult() {
    }

    RailThirdPartyAccountInfo account_info;
};

}  // namespace rail_event

#pragma pack(pop)
}  // namespace rail

#endif  // RAIL_THIRD_PARTY_ACCOUNT_LOGIN_DEFINE_H
