// Copyright (C) 2025 Tencent. All rights reserved.

#ifndef RAIL_THIRD_PARTY_PLATFORM_LOGIN_H
#define RAIL_THIRD_PARTY_PLATFORM_LOGIN_H

#include "rail/sdk/rail_third_party_platform_login_define.h"

namespace rail {
#pragma pack(push, RAIL_SDK_PACKING)

class IRailThirdPartyPlatformLoginHelper {
  public:
    virtual RailResult AsyncLogin(const RailThirdPartyPlatformLoginOptions& options,
                        const RailString& user_data) = 0;

    virtual RailResult GetLoggedInUserInfo(RailThirdPartyPlatformUserInfo* user_info) = 0;

    virtual RailResult AsyncAcquirePlatformSessionTicket(const RailString& user_data) = 0;
};

#pragma pack(pop)
}  // namespace rail

#endif  // RAIL_THIRD_PARTY_PLATFORM_LOGIN_H
