// Copyright (C) 2025 Tencent. All rights reserved.

#ifndef RAIL_THIRD_PARTY_PLATFORM_LOGIN_DEFINE_H
#define RAIL_THIRD_PARTY_PLATFORM_LOGIN_DEFINE_H

#include "rail/sdk/base/rail_define.h"
#include "rail/sdk/rail_event.h"

namespace rail {
#pragma pack(push, RAIL_SDK_PACKING)

struct RailThirdPartyPlatformLoginOptions {
    RailThirdPartyPlatformLoginOptions() {
        platform_game_id = 0;
    }

    uint64_t platform_game_id;
};

struct RailThirdPartyPlatformUserInfo {
    RailThirdPartyPlatformUserInfo() {
    }

    RailID rail_id;
    RailString nick_name;
    RailString avatar_url;
};

namespace rail_event {

struct RailThirdPartyPlatformLoginResult
    : public RailEvent<kRailThirdPartyPlatformLoginResult> {
    RailThirdPartyPlatformLoginResult() {
        result = kFailure;
    }
};

struct RailAcquirePlatformSessionTicketResult
    : public RailEvent<kRailThirdPartyPlatformAcquirePlatformSessionTicketResult> {
    RailAcquirePlatformSessionTicketResult() {
        ticket_expire_time = 0;
    }

    RailString session_ticket;
    uint32_t ticket_expire_time;  // the session ticket expiration time, in seconds. For example
                                  // return 3600 means expire in one hour. The default validity
                                  // period is 72 hours.
};
}  // namespace rail_event

#pragma pack(pop)
}  // namespace rail

#endif  // RAIL_THIRD_PARTY_PLATFORM_LOGIN_DEFINE_H
