//
//  HGAnalyticsManager.h
//  HeroGlobal
//
//  Created by 魏太山 on 2021/11/2.
//  Copyright © 2021 . All rights reserved.
//
//  数据埋点类，负责上报埋点数据

#import <Foundation/Foundation.h>
#import "SynthesizeSingleton_ARC.h"

NS_ASSUME_NONNULL_BEGIN

@interface HGAnalyticsManager : NSObject
ARC_SYNTHESIZE_SINGLETON_FOR_CLASS_HEADER;

/** url */
@property (nonatomic, copy) NSString *trackUrl;

/** 开启日志 */
@property (nonatomic, assign) BOOL enableLog;

/** 初始化数据SDK*/
- (void)startWithLaunchOptions:(NSDictionary *)launchOptions;

/**
 * @abstract
 * 调用 track 接口，追踪一个带有属性的 event
 *
 * @discussion
 * propertyDict 是一个 Map。
 * 其中的 key 是 Property 的名称，必须是 NSString
 * value 则是 Property 的内容，只支持 NSString、NSNumber、NSSet、NSArray、NSDate 这些类型
 * 特别的，NSSet 或者 NSArray 类型的 value 中目前只支持其中的元素是 NSString
 *
 * @param event             event的名称
 * @param propertyDict     event的属性
 */
- (void)track:(NSString *)event withProperties:(nullable NSDictionary *)propertyDict;

/**
 开始事件计时

 @discussion
 若需要统计某个事件的持续时间，先在事件开始时调用 trackTimerStart:"Event" 记录事件开始时间，该方法并不会真正发送事件；
 随后在事件结束时，调用 trackTimerEnd:"Event" withProperties:properties，
 SDK 会追踪 "Event" 事件，并自动将事件持续时间记录在事件属性 "event_duration" 中，时间单位为秒。

 @param event 事件名称
 @return 返回计时事件的 eventId，用于交叉计时场景。普通计时可忽略
 */
- (nullable NSString *)trackTimerStart:(NSString *)event;

/**
 结束事件计时

 @discussion
 多次调用 trackTimerEnd: 时，以首次调用为准

 @param event 事件名称或事件的 eventId
 @param propertyDict 自定义属性
 */
- (void)trackTimerEnd:(NSString *)event withProperties:(nullable NSDictionary *)propertyDict;


/** 通过key获取信息，给数据SDK使用 */
- (NSString *)getParameterWithKey:(NSString *)key;

/** 改变渠道切换时sessionid */
- (void)changeChannelAccountSessionId;

/** 获取埋点设备id */
- (NSString *)getDistinctId;

/** 获取埋点会话id */
- (NSString *)getSessionId;

/** 获取埋点账号会话id */
- (NSString *)getAccountSessionId;

/** 获取埋点渠道切账号会话id */
- (NSString *)getChannelSessionId;

/** 获取AFID */
- (NSString *)getAFId;

/** 上报市场SDK和USDK插件市场SDK的 AF上报 */
- (void)sendMarketAFWithTrackEvent:(NSString *)eventName withValues:(NSDictionary*)values;
@end

NS_ASSUME_NONNULL_END
