//
//  HGErrorManager.h
//  HeroGlobalSDK
//
//  Created by 魏太山 on 2023/3/17.
//  Copyright © 2023 . All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SynthesizeSingleton_ARC.h"
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface HGErrorModel : NSObject

@property(nonatomic, assign) NSInteger code;

@property(nonatomic, copy) NSString *message;

@property(nonatomic, copy) NSString *tip;

@property(nonatomic, copy) NSString *details;

- (NSString *)toString;

- (NSDictionary *)toDictionary;

@end

@interface HGErrorManager : NSObject
ARC_SYNTHESIZE_SINGLETON_FOR_CLASS_HEADER;

/** 所有提示字典 */
@property(nonatomic, strong, readonly) NSDictionary *info;

/** 根据 key 获取 error model*/
- (HGErrorModel *)getErrorWithKey:(NSString *)key;

/** 将 string 转换为 error model*/
- (HGErrorModel *)formatErrorDictionaryWithString:(NSString *)str;

/** 获取服务器返回的 error.tip ，如果没有，则使用 error_description ，如果都没有，则使用 backError */
- (NSString *)getServerErrorTipWith:(NSDictionary *)result backError:(NSString *)backError;

@end

NS_ASSUME_NONNULL_END
