//
//  HGSwiftBridgeManager.h
//  HeroGlobal
//
//  Created by 魏太山 on 2022/3/2.
//  Copyright © 2022 . All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, HGEmailCodeType) {
    HGEmailCodeTypeLogin = 0, // 邮箱验证码 登录
    HGEmailCodeTypeBind, // 邮箱验证码 绑定
    HGEmailCodeTypeUnBind, // 邮箱验证码 解绑
    HGEmailCodeTypeSetPwd, // 邮箱验证码 设置密码
    HGEmailCodeTypeUpdatePwd, // 邮箱验证码 更新密码
    HGEmailCodeTypeSecurity, // 邮箱验证码 换设备触发安全验证
};

typedef NS_ENUM(NSUInteger, LoginType) {
    LoginType_tourist = 0,       //游客
    LoginType_Facebook = 1,      //1 Facebook
    LoginType_Google = 2,        //google
    LoginType_GameCenter = 3,    //GameCenter
    LoginType_Wechat = 4,        //WeChat
    LoginType_Twitter = 5,       //Twitter
    LoginType_Suid = 6,          //引继码
    LoginType_Apple = 7,         //Apple
    LoginType_LINE = 8,          //LINE
    LoginType_ACCOUNT = 9,       //账号密码登录
    LoginType_GameWith = 12,     //Gamewith登录
    LoginType_Email = 16,        //邮箱登录
    LoginType_VK = 30,           //VK登录
};

typedef NS_ENUM(NSUInteger, BindType) {
    BindType_Facebook = 1,       //1 Facebook
    BindType_Google = 2,         //google
    BindType_GameCenter = 3,     //GameCenter
    BindType_wechat = 4,         //WeChat
    BindType_Twitter = 5,        //WeChat
    BindType_Apple = 7,          //Apple
    BindType_Line = 8,           //Line
    BindType_GameWith = 12,      //GameWith
    BindType_Email = 16,         //Email
    BindType_VK = 30,            //VK登录
};


NS_ASSUME_NONNULL_BEGIN
typedef void(^HGCompleteBlock)(NSDictionary<NSString *, id> *resultData, NSString *error);
typedef void(^HGSureBlock)(void);

@interface HGSwiftBridgeManager : NSObject
+ (instancetype)sharedInstance;

- (void)networkWithUrl:(NSString *)url params:(NSMutableDictionary *)params completion:(HGCompleteBlock)completion;

- (void)showPayErrorViewWithCompletion:(HGSureBlock)completion;

- (void)showPayLimitViewWithCompletion:(HGSureBlock)completion;

/**
 payDetainmentConf json字符串 "{\"type\":\"1\",\"content\":\"https://herogames.feishu.cn/wiki/UJwcwbYFUi1fn2kgYE8caG7fnfy\"}";
 */
- (void)showPayCancelViewWithPayDetainmentConf:(NSString *)payDetainmentConf
                                  cancelHandle:(HGSureBlock)cancelHandle
                                continueHandle:(HGSureBlock)continueHandle;

/** 支付成功上报的AF和埋点SDK*/
- (void)sendMarketAFPaySuccessWithModel:(NSDictionary *)model;

- (void)showPayRealNameViewWithSuccessHandle:(HGSureBlock)successHandle
                                cancelHandle:(HGSureBlock)cancelHandle;

@end

NS_ASSUME_NONNULL_END
