//
//  HeroPublicTag.h
//  HeroGlobal
//
//  Created by 谢宗文 on 2017/9/25.
//  Copyright © 2017年 谢宗文. All rights reserved.
//

#ifndef HeroPublicTag_h
#define HeroPublicTag_h


typedef NS_ENUM(NSInteger, HeroSharePlatform) {
    Hero_Share_Platform_FaceBook     = 1,   //分享到 Facebook
    Hero_Share_Platform_Twitter      = 2,   //分享到 Twitter
    Hero_Share_Platform_Line         = 3,   //分享到 LINE
    Hero_Share_Platform_Instagram    = 4,   //分享到 Instagram
    Hero_Share_Platform_Tiktok       = 5,   //分享到 Tiktok
    Hero_Share_Platform_KaKao        = 6,   //分享到 KaKao
    Hero_Share_Platform_Discord      = 7,   //分享到 Discord
    Hero_Share_Platform_LunoLoft     = 8,   //分享到 LunoLoft
    Hero_Share_Platform_SAVE         = 200, //保存相册
};

typedef NS_ENUM(NSInteger, HeroShareType) {
    HeroShareType_image = 0, //分享图片
    HeroShareType_link  = 1, //分享链接
    HeroShareType_text  = 2, //分享文字
};

typedef NS_ENUM(NSInteger, HeroShareStatus) {
    HeroShareStatus_success = 0, //分享成功
    HeroShareStatus_failed  = 1, //分享失败
    HeroShareStatus_cancel  = 2, //分享取消
};

typedef NS_ENUM(NSInteger, HeroShareTaget) {
    HeroShareTaget_FaceBook      = 1,   //分享到 Facebook
    HeroShareTaget_Twitter       = 2,   //分享到 Twitter
    HeroShareTaget_Line          = 3,   //分享到 Line
    HeroShareTaget_Instagram     = 4,   //分享到 Instagram
    HeroShareTaget_Tiktok        = 5,   //分享到 Tiktok
    HeroShareTaget_KaKao         = 6,   //分享到 KaKao
    HeroShareTaget_Discord       = 7,   //分享到 Discord
    HeroShareTaget_LunoLoft      = 8,   //分享到 LunoLoft
    HeroShareTaget_Save          = 200, //保存图片
};

typedef NS_ENUM(NSInteger, HeroLanguageType) {
    /** 系统默认 */
    HeroLanguageTypeSystem = 0,
    /** 简体中文 */
    HeroLanguageTypeZhHans = 1,
    /** 繁体中文 */
    HeroLanguageTypeZhHant = 2,
    /** 英语 */
    HeroLanguageTypeEn = 3,
    /** 日语 */
    HeroLanguageTypeJa = 4,
    /** 韩语 */
    HeroLanguageTypeKo = 5,
};

/*
 *  ===================================登录相关通知宏定义========================================
 */

//登录成功
#define Hero_Login_Success_Notification          @"Hero_Login_Success_Notification"

//切换账号
#define Hero_Login_Change_Notification @"Hero_Login_Change_Notification"

//需要注册账号
#define Hero_Need_Register_Notification @"Hero_Need_Register_Notification"

//退出登录
#define Hero_Exit_Login_Notification @"Hero_Global_Exit_Login_Notification"

/*
 *  ===================================内购通知宏定义========================================
 */
//内购成功
#define Hero_Iap_Notification       @"Hero_Iap_Notification"


#endif /* HeroPublicTag_h */
