//
//  HeroUShare.h
//  HeroUSDK
//
//  Created by 魏太山 on 2020/10/27.
//  Copyright © 2020 Hero. All rights reserved.
//
//  本类负责HeroU【分享插件】相关操作

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, HeroUSharePlatform) {
    
    /**QQ好友*/
    HeroU_Share_Platform_QQ              = 1,
    /**QQ空间*/
    HeroU_Share_Platform_QQ_Space        = 2,
    /**微信好友*/
    HeroU_Share_Platform_WeChat          = 3,
    /**微信朋友圈*/
    HeroU_Share_Platform_WXTimeLine      = 4,
    /**微博*/
    HeroU_Share_Platform_Weibo           = 5,
    /**小红书*/
    HeroU_Share_Platform_XiaoHongShu     = 20,
    /**抖音分享到投稿发布*/
    HeroU_Share_Platform_DouYinPublished = 21,
    /**抖音分享到日常*/
    HeroU_Share_Platform_DouYinDaily     = 22,
    /**抖音分享到好友*/
    HeroU_Share_Platform_DouYinIM        = 23,
    /**快手*/
    HeroU_Share_Platform_KuaiShou        = 24,
    /**TapTap*/
    HeroU_Share_Platform_TapTap          = 25,
    /**摸鱼社-动态*/
    HeroU_Share_Platform_MoyuDynamic     = 26,
    /**摸鱼社-文章*/
    HeroU_Share_Platform_MoyuArticle     = 27,
    /**有界面分享*/
    HeroU_Share_Platform_All             = 6,

    //以下仅限全球渠道使用   且需要游戏自绘按钮
    /**twitter*/
    HeroU_Share_Platform_Twitter         = 7,
    /**facebook*/
    HeroU_Share_Platform_Facebbok        = 8,
    /**Line**/
    HeroU_Share_Platform_Line            = 9,
    /**Instagram**/
    HeroU_Share_Platform_Instagram       = 10,
    /**Tiktok**/
    HeroU_Share_Platform_Tiktok          = 11,
    /**Kakao**/
    HeroU_Share_Platform_Kakao           = 12,
    /**discord**/
    HeroU_Share_Platform_Discord         = 13,
    /**LunoLoft**/
    HeroU_Share_Platform_LunoLoft        = 14,
    
    // 通用，系统分享
    HeroU_Share_Platform_System          = 1000
};

typedef NS_ENUM(NSInteger, HeroUShareType) {
    HeroUShareType_image = 0, //分享图片
    HeroUShareType_link  = 1, //分享链接
    HeroUShareType_text  = 2, //分享文本
};

typedef NS_ENUM(NSInteger, HeroUShareStatus) {
    HeroUShareStatus_success = 0, //分享成功
    HeroUShareStatus_failed  = 1, //分享失败
    HeroUShareStatus_cancel  = 2, //分享取消
};

typedef NS_ENUM(NSInteger, HeroUShareTaget) {
    HeroUShareTaget_QQ               = 1,   //分享到QQ
    HeroUShareTaget_QQSpace          = 2,   //分享到QQ空间
    HeroUShareTaget_wechat           = 3,   //分享到微信
    HeroUShareTaget_wechatLine       = 4,   //分享到朋友圈
    HeroUShareTaget_Weibo            = 5,   //分享到微博
    HeroUShareTaget_Twitter          = 7,   //分享到twitter
    HeroUShareTaget_Facebbok         = 8,   //分享到facebbok
    // v5.2.0版本新增
    HeroUShareTaget_Line             = 9,   //分享到Line
    HeroUShareTaget_Instagram        = 10,  //分享到Instagram
    HeroUShareTaget_Tiktok           = 11,  //分享到Tiktok
    HeroUShareTaget_Kakao            = 12,  //分享到Kakao
    HeroUShareTaget_Discord          = 13,  //分享到Discord
    HeroUShareTaget_LunoLoft         = 14 , //分享到LunoLoft
    HeroUShareTaget_XiaoHongShu      = 20,  //分享到XiaoHongShu
    HeroUShareTaget_DouYinPublished  = 21,  //分享到DouYin发布
    HeroUShareTaget_DouYinDaily      = 22,  //分享到DouYin日常
    HeroUShareTaget_DouYinIM         = 23,  //分享到DouYin好友
    HeroUShareTaget_KuaiShou         = 24,  //分享到KuaiShou
    HeroUShareTaget_TapTap           = 25,  //分享到TapTap
    HeroUShareTaget_MoyuDynamic      = 26,  //分享到摸鱼社-动态
    HeroUShareTaget_MoyuArticle      = 27,  //分享到摸鱼社-文章
    // 通用，系统分享
    HeroUShareTaget_System           = 1000
};

NS_ASSUME_NONNULL_BEGIN

@interface HeroUShare : NSObject

@end

@interface HeroUShareModel : NSObject
@property (nonatomic,assign) HeroUShareType      shareType; //分享类型 （必填）
@property (nonatomic,assign) HeroUSharePlatform  sharePlatform ; //分享平台（必填）
//分享图片需要填写的参数
@property (nonatomic,strong) NSData            *shareImage;//分享图片（分享图片与链接2选一）
@property (nonatomic,copy  ) NSString          *imageLink;//分享图片链接（分享图片与链接2选一）
//分享链接需要填写的参数
@property (nonatomic,copy  ) NSString          *shareLink;//分享链接 （分享链接必填）
@property (nonatomic,copy  ) NSString          *shareLinkTitle;//分享链接标题（分享链接必填）
@property (nonatomic,copy  ) NSString          *shareLinkDescription;//分享链接描述（分享链接必填）
//分享文本需要填写的参数
@property (nonatomic,copy  ) NSString          *shareText;//分享纯文本文字 （分享纯文本必填）
@property (nonatomic,copy  ) NSString          *shareTextContent;//分享纯文本描述 （分享纯文本选填）
@end

NS_ASSUME_NONNULL_END




