//
//  GameBaseAlertView.h
//  GameChinaLegal
//
//  Created by Mr.Li on 16/5/5.
//  Copyright © 2016年 Game. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GameBaseButton.h"
#import "HMLoadingView.h"
#if TargetUltra
#import <UltraBaseSDK/UIColor+HBExtension.h>
#else
#import <HeroBaseSDK/UIColor+HBExtension.h>
#endif

#define HERO_TF_TIP_ALIAS               @"请输入用户名（6~16位字母数字组合）"
#define HERO_TF_TIP_PASSWORD            @"密码长度为6~16位字母、数字组成，区分大小写"
#define HERO_TF_TIP_PHONENUM            @"支持（+86）中国区11位手机号"
#define HERO_TF_TIP_REALNAME            @"请填写真实中文姓名"
#define HERO_TF_TIP_IDCARD              @"请填写正确18位身份证号码"
#define HERO_TF_TIP_ACCOUNT             @"手机号/邮箱/用户名"
#define HERO_TF_TIP_AUTHCODE            @"请输入4位短信验证码"

//输入框底部的线编辑时颜色
#define HERO_TEXTFIELD_EDITING_COLOR Get_Hero_New_MainColor
//输入框底部的线正常颜色
#define HERO_TEXTFIELD_EDIT_COLOR [UIColor colorWithRed:161/255.0 green:161/255.0 blue:161/255.0 alpha:0.5]


@interface GameBaseAlertView : UIView

@property (nonatomic, strong) UIImageView    *whiteImageView;
@property (nonatomic, strong) UILabel        *titleLable;
@property (nonatomic, strong) UIImageView    *logoImage;
@property (nonatomic, strong) GameBaseButton *backBtn;

@property (nonatomic, strong) HMLoadingView *activityView;
//@property (nonatomic, strong) UIView *activityBgview;
//@property (nonatomic, strong) UIView *baseBgView;

//返回block
@property (nonatomic, copy) void (^backBlock)(void);

/**初始化，子类调用用于初始化自己的东西*/
- (void)initViews;

- (UIViewController *)appRootViewController;

- (void)showHUD;

- (void)hideHUD;

- (UILabel *)setTFTipLabelWithText:(NSString *)text;

- (void)keyboardWillShow:(NSNotification *)noti ;
- (void)keyboardWillHide:(NSNotification *)noti ;

- (void)pushToAlertView:(id)alertView;

- (void)popView;
- (void)backToPopView ;

- (void)popToView:(id)alertView ;

- (void)popToRootView;
- (void)popToOldLoginView;
- (void)popToOldLoginViewFromFloat ;

- (BOOL)isPortrait;

- (void)addObserver;

- (void)addAnimationWithView:(UIView *)view subtype:(CATransitionSubtype)subtype type:(CATransitionType)type;

//屏幕旋转通知
-(void)changeOrientation ;


/** 从右到左弹出动画 */
- (void)pushAnimationToAlertView:(id)alertView;

/** 从左到→弹出动画 */
- (void)popAnimationView;
- (void)popAnimationToView:(id)alertView;
- (void)popAnimationToRootView;

/** 从底部网上弹出动画 */
- (void)animationShow;

/** 淡入淡出动画 */
- (void)animationFadeShow;

- (void)animationDismissWithView:(UIView *)view completion:(void (^)(void))completionBlock;

@end
