//
//  GameBasePaymentOrder.h
//  DevPaymentClient
//
//  Created by Gang.Liu on 14-4-24.
//  Copyright (c) 2014年 zhouqing. All rights reserved.
//

#import <Foundation/Foundation.h>

#define INFODICT(orderId,orderAmount,currency,errorCode) @{@"orderId":orderId,@"orderAmount":orderAmount,@"currency":currency,@"errorCode":@(errorCode)}

@interface GameBasePaymentOrder : NSObject
{
@protected
    NSString * _orderId;
    NSString * _orderAmount;
    NSString * _currency;
    NSInteger _errorCode;
    NSString * _errorDescription;
    
}

@property (nonatomic, strong) NSString *orderId;     //支付订单号
@property (nonatomic, strong) NSString *orderAmount; //支付金额
@property (nonatomic, strong) NSString *currency;//币种
@property (nonatomic, assign) NSInteger errorCode;//iap购买失败原因（以苹果服务器返回code为准）
@property (nonatomic, strong) NSString *errorDescription;//iap购买失败原因苹果返回的解释

- (void)setNotificationWithDict:(NSDictionary *)payInfo;

@end
