//
//  GameTeenagersAlertView.h
//  CmgeChinaLegal
//
//  Created by 魏太山 on 2020/4/20.
//  Copyright © 2020 . All rights reserved.
//

#import "GameBaseAlertView.h"

NS_ASSUME_NONNULL_BEGIN

typedef enum : NSUInteger {
    TeenagersViewTypeLogin = 0, //登录弹框
    TeenagersViewTypePay, //支付弹框
    TeenagersViewTypeNotice, //弹框
} TeenagersViewType ;

@interface GameTeenagersAlertView : GameBaseAlertView

//返回block
@property (nonatomic, copy) void (^sureBlock)(void);

/** content */
@property (nonatomic, strong) NSString *time;
- (void)show;

- (instancetype)initWithTime:(NSString *)time
                     content:(NSString *)content
                        type:(TeenagersViewType)type ;
@end

NS_ASSUME_NONNULL_END
