

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "HMCommonPlatformDefines.h"

@class HGamePaymentParameters;
@class HGameProject;

extern NSString * const GAME_NOTIFICATION_IAP_IOS11;


@interface HGamePlatform : NSObject

/*
 *  设置URL
 */
@property (nonatomic, copy) NSString *serverUrl;

/**
 @brief 获取HMCommonPlatform的实例对象
 */
+ (HGamePlatform *)defaultPlatform;

/**
@brief 读取配置初始化
*/
- (void)initWithHeroConfigProperty ;

/**
 @brief 设置项目参数
 @param project 项目设置参数对象
 @note 调用SDK之前必须保证HGameProject对象的各项参数正确设置
 */
- (void)launchingPlatformWithApplication:(UIApplication *)application
                                 project:(HGameProject *)project
                         withOptions:(NSDictionary *)launchOptions;

/**
 @brief  注销、退出登陆
 @result 0表示方法调用成功  其他结果请参考HMCommonPlatformError.h
 */
- (int)logout;

/**
 @brief  注销、退出登陆
 @result 0表示方法调用成功  其他结果请参考HMCommonPlatformError.h
 */
- (int)logoutAndSowLoginView;

/**
 @brief  调用SDK默认的登陆界面
 @result 0表示方法调用成功  其他结果请参考HMCommonPlatformError.h
 @note   如果开发者想自定义用户登陆界面，请调用后序用户相关的接口方法
 */
- (int)enterLoginView;

/*
 *  账号删除
 *  调用此接口会弹出删除账号界面，删除账号后服务器也会删除，请谨慎操作
 */
- (void)accountCancellation;

/*
 *  清空用户存储
 */
- (void)cleanUserEntities;

/**
 @brief 调用SDKIAP内购
 @param paymentParametersData iap支付参数配置
 @result 0表示方法调用成功
 */
- (int)iapPurchaseWithData:(HGamePaymentParameters *)paymentParametersData;

/**兑换礼品卡或代码*/
- (void)redeemGiftCardOrCodeWithData:(NSMutableDictionary *)data
                             success:(void (^)(NSDictionary *dic))success
                             failure:(void (^)(NSString *error))failure;

/** iOS 15支付补单 */
- (void)iOS15SupplementOrder;

/**
 *  设置Game SDK内部是否为公共版
 *  如果设置为YES, 那么为公共版
 *  如果设置为NO, 那么为非公共版
 */
- (void)setPublicLogin:(BOOL)publicLogin;


/**
 设置game SDK是否为单机版
 
 @param isOnlineGame 如果设置YES,那么为单机版，如果设置为NO，那么为网游版
 
 */
- (void)setIsOnlineGame:(BOOL)isOnlineGame;

/**
 *  当前是否已经登录
 *
 *  @return YES 已经登录
 *          NO 没有登录
 */
- (BOOL)isLogined;

/**
 @brief 获取登录用户名
 @result 若用户没登录，则返回nil
 */
- (NSString *)getUserName;

/**
 @brief 获取登录用户ID
 @result 若用户没登录，则返回nil
 */
- (NSString *)getUserId;

/**
 @brief 获取ID（部分游戏使用@"id"字段作为唯一标示符）
 @result 若用户没登录，则返回nil
 */
- (NSString *)getSdkId;

/**
 *  角色注册登记
 *
 *  @param serverId    游戏区服ID
 *  @param serverName    游戏区服名称
 *  @param roleId    角色ID
 *  @param roleName    角色名称
 *  @param roleAvatar    角色头像
 *  @param access_token    登录完成后获取的access_token
 
 */
- (void)roleRegisterWithServerId:(NSString *)serverId
                      serverName:(NSString *)serverName
                          roleId:(NSString *)roleId
                        roleName:(NSString *)roleName
                      roleAvatar:(NSString *)roleAvatar
                    access_token:(NSString *)access_token;


/**
 进入用户中心
 */
-(void)enterUserCenterView ;

/**
 打开广告页
 */
- (void)openAdView;

/**
 获取打开广告页面状态
 
 @param status 回调
 */
- (void)showAdViewWithStatus:(void(^)(BOOL))status;

/**
 单机登陆
 */
- (void)enterAloneGame;

/*
 *  获取第三方登录的key
 */
- (NSDictionary *)getLoginkeys;

/*
 *  登录返回来的回调
 */

- (void)handleOpenURL:(NSURL *)url;

/*
*  微信返回来的回调
*/
- (BOOL)handleOpenUniversalLink:(NSUserActivity *)userActivity ;

/*
 * 获取设备号(优先取的IDFA、没取到则取的UUID)
 */
- (NSString *)getDeviceNum;

/*
 * 上报闪屏结束
 */
- (void)postSplashScreenEndSuccess:(void (^)(id obj))success
                             faild:(void (^)(id obj))faild;

/*
 *  ================================================上报数据==========================================================
 */

/*
 *  角色登录
 */
- (void)roleLoginWithGameRoleInfo:(id)gameRoleInfo;

/*
 *  角色注册
 */
- (void)roleRegisterWithGameRoleInfo:(id)gameRoleInfo;

/*
 *  角色升级
 */
- (void)roleLevelUpWithGameRoleInfo:(id)gameRoleInfo;

/**
 开始扫描
 */
- (void)launchBarcodeScannerWithExt:(NSString *)ext controller:(UIViewController *)controller;

/**
 设置礼包浮标位置
 @param position 浮标位置
 */
- (void)initFloatView:(CGPoint)position ;

/**
下线回传
@param result 结果
*/
- (void)cpKickOffCallBackWithResult:(NSDictionary *)result ;

/*
 * 获取当前登录用户的信息接口
 */
- (void)requestUserInfoSuccess:(void (^)(id obj))success
                             faild:(void (^)(id obj))faild ;

/*
 * 打开客服界面
 */
- (void)openServiceView;


@end

