//
//  HeroBlocSharePlatform.h
//  BlocSDK
//
//  Created by 谢宗文 on 2017/3/23.
//  Copyright © 2017年 Li. All rights reserved.
//  分享平台

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>


typedef NS_ENUM(NSInteger, HeroSharePlatform) {
    
    Hero_Share_Platform_QQ = 1, //QQ好友
    Hero_Share_Platform_QQ_Space, //QQ空间
    Hero_Share_Platform_WeChat, //微信好友
    Hero_Share_Platform_WXTimeLine, //朋友圈
    Hero_Share_Platform_Weibo,
    Hero_Share_Platform_HeroCommunity //英雄社区
};

typedef NS_ENUM(NSInteger, HeroShareType) {
    HeroShareType_image = 0, //分享图片
    HeroShareType_link  = 1, //分享链接
    HeroShareType_text  = 2, //分享文本
};

typedef NS_ENUM(NSInteger, HeroShareStatus) {
    HeroShareStatus_success = 0, //分享成功
    HeroShareStatus_failed  = 1, //分享失败
    HeroShareStatus_cancel  = 2, //分享取消
};

typedef NS_ENUM(NSInteger, HeroShareTaget) {
    HeroShareTaget_wechat      = 1, //分享到微信
    HeroShareTaget_wechatLine  = 2, //分享到朋友圈
    HeroShareTaget_QQ          = 3, //分享到QQ
    HeroShareTaget_QQSpace     = 4, //分享到QQ空间
    HeroShareTaget_Weibo       = 6, //分享到微博
};

@interface HeroShareModel : NSObject


@property (nonatomic,assign) HeroShareType      shareType; //分享类型 （必填）
@property (nonatomic,assign) HeroSharePlatform  sharePlatform ; //分享平台（必填）
//分享图片需要填写的参数
@property (nonatomic,strong) NSData            *shareImage;//分享图片（分享图片与链接2选一）
@property (nonatomic,copy  ) NSString          *imageLink;//分享图片链接（分享图片与链接2选一）
//分享链接需要填写的参数
@property (nonatomic,copy  ) NSString          *shareLink;//分享链接 （分享链接必填）
@property (nonatomic,copy  ) NSString          *shareLinkTitle;//分享链接标题（分享链接必填）
@property (nonatomic,copy  ) NSString          *shareLinkDescription;//分享链接描述（分享链接必填）
//分享文本需要填写的参数
@property (nonatomic,copy  ) NSString          *shareText;//分享纯文本文字 （分享纯文本必填）

@end

@interface HeroBlocSharePlatform : NSObject

/**
 单利对象方法
 */
+ (HeroBlocSharePlatform*)shareInstance ;

/*
 *  初始化QQ
 */
- (void)initWithQQkey:(NSString *)key universalLink:(NSString *)universalLink ;
/*
 *  初始化微信
 */
- (void)initWithWechatKey:(NSString *)key universalLink:(NSString *)universalLink ;
/*
 *  初始化微博
 */
- (void)initWithWeiboKey:(NSString *)key ;
/**
 *  是否安装QQ
 */
- (BOOL)isQQInstalled;
/**
 *  是否安装微信
 */
- (BOOL)isWXAppInstalled;
/**
 *  是否安装微博
 */
-(BOOL)isWeiboAppInstalled;

//设置界面分享方式YES 代表关闭该分享方式 默认打开
@property (nonatomic, assign) BOOL closeQQ;//是否关闭QQ分享
@property (nonatomic, assign) BOOL closeQQSpace;//是否关闭QQ空间分享
@property (nonatomic, assign) BOOL closeWechat;//是否关闭微信分享
@property (nonatomic, assign) BOOL closeWechatLine;//是否关闭朋友圈分享
@property (nonatomic, assign) BOOL closeWeibo;//是否关闭微博分享

/*
 * 有分享界⾯面 - shareModels为分享数据模型，包含分享链接、描述、分享类型等必要参数
 * success成功回调 failure失败回调
 */
- (void)showShareViewWithShareDataArray:(NSArray *)shareModels
                           success:(void(^)(NSString *successMessage,HeroShareStatus status,HeroShareTaget target))success
                           failure:(void(^)(NSString *failureMessage,HeroShareStatus status,HeroShareTaget target))failure;
/*
 * 分享--⽆无分享界⾯面
 * shareModel为分享数据模型，包含分享链接、描述、分享类型等必要参数
 * success成功回调 failure失败回调 */
- (void)shareWithShareData:(HeroShareModel *)shareModel
                   success:(void(^)(NSString *successMessage,HeroShareStatus status,HeroShareTaget target))success
                   failure:(void(^)(NSString *failureMessage,HeroShareStatus status,HeroShareTaget target))failure;


/**
 微信、QQ回调
 */
- (BOOL)application:(UIApplication *)app
            openURL:(NSURL *)url
            options:(NSDictionary<UIApplicationOpenURLOptionsKey,id> *)options;
/**
 微信、QQ回调
 */
- (BOOL)application:(UIApplication *)application
            openURL:(NSURL *)url
  sourceApplication:(NSString *)sourceApplication
         annotation:(id)annotation ;

/**
 微信、QQ回调
 */
- (BOOL)application:(UIApplication *)application
      handleOpenURL:(NSURL *)url ;

/*
*  微信返回来的回调
*/
- (BOOL)handleOpenUniversalLink:(NSUserActivity *)userActivity  API_AVAILABLE(ios(8.0));


/*
 * 单独处理微博回调
 */
- (BOOL)sigleWeiBoApplication:(UIApplication *)application
                handleOpenURL:(NSURL *)url ;

@end
