//
//  BlocManager.h
//  BlocSDK
//
//  Created by Mr.Li on 16/6/21.
//  Copyright © 2016年 Li. All rights reserved.
//

#import <Foundation/Foundation.h>
@class BlocRoleInfoData;

@interface BlocManager : NSObject

+ (BlocManager *)sharedInstance;

@property (nonatomic, copy  ) NSString * gameId;            //游戏id
@property (nonatomic, copy  ) NSString * key;               //密钥
@property (nonatomic, copy  ) NSString * channelId;         //渠道id
@property (nonatomic, copy  ) NSString * serverId;          //服务id
@property (nonatomic, copy  ) NSString * roleId;            //角色id
@property (nonatomic, copy  ) NSString * channelUserId;     //渠道用户id
@property (nonatomic, copy  ) NSString * gameUserId;        //渠道用户id
@property (nonatomic, copy  ) NSString * roleName;          //角色名称
@property (nonatomic, copy  ) NSString * level;          //角色名称
@property (nonatomic, copy  ) NSString * serverName;        //服务器名称名称
@property (nonatomic, copy  ) NSString *ts;                 //时间
@property (nonatomic, copy  ) NSString *devNum;             //设备号
@property (nonatomic, copy  ) NSString *plat;               //平台
@property (nonatomic, copy  ) NSString *vc;                 //CFBundleVersion版本号
@property (nonatomic, copy  ) NSString *vg;                 //CFBundleShortVersionString 版本号
@property (nonatomic, copy  ) NSString *vs;                 //sdk版本号
@property (nonatomic, copy  ) NSString *vo;                 //系统版本
@property (nonatomic, copy  ) NSString *roleKey;            //角色ID摘要     MD5(Jar+gu+gs+gr+role),小写
@property (nonatomic, copy  ) NSString *r_base;             //r_base基础数据

@property (nonatomic, copy  ) NSString *roleToken;          //角色Token

@property (nonatomic, copy  ) NSString *roleUrl;            //用于java服务器上报地址
@property (nonatomic, copy  ) NSString *mainStrategyUrl;    //用于php服务器请求地址

@property (nonatomic, strong) NSMutableDictionary *roleDic;     //角色数据
@property (nonatomic, strong) BlocRoleInfoData *roleInfoData;   //角色数据模型
@property (nonatomic, strong) NSString *sdkVersion;             //sdk版本
@property (nonatomic, copy  ) NSString *currLang;               //系统语言
@property (nonatomic, copy  ) NSString *countryCode;            //国家地区

@property (nonatomic, assign) BOOL isDebug;                     //调试开关
@property (nonatomic, assign) BOOL isCircleLoad;                //是否轮询
@property (nonatomic, assign) BOOL isOpenVoice;                 //是否在使用电台/录屏/语音转文字，三者只能同时使用一个
@property (nonatomic, assign) BOOL isPlayVideo;                 //社区是否在播放视频
@property (nonatomic, assign) NSInteger sharetype;              //分享类型
@property (nonatomic, assign) NSInteger timeUpdate;             //时间修正差值
@property (nonatomic, strong) NSDate *requestDate;              //请求时间

//rid
@property (nonatomic, copy  ) NSString *rid ;                     //角色主键ID
@property (nonatomic, copy  ) NSString * tempRoleId;              //临时角色id，只记录进入游戏的第一次角色id
@property (nonatomic, assign) BOOL isLiveRoleChange ;             //是否切换了直播角色


- (NSDictionary *)getBaseParame;

- (NSString *)getBaseParameString;

@end

