//
//  HeroAppManager.h
//  HeroMoyuSDK
//
//  Created by Hero on 2024/8/22.
//

#import <Foundation/Foundation.h>

//分享内容类型枚举
typedef NS_ENUM(NSInteger , ShareContentType) {
    Image,  //图片
    Link    //链接
};

//展示的位置
typedef NS_ENUM(NSInteger, ShowType) {
    Web,        //H5打开展示
    PostDetail, //帖子详情打开展示
    Editor      //编辑器打开展示
};

//编辑器展示类型
typedef NS_ENUM(NSInteger, EditorType) {
    Dynamic,    //动态
    Article,    //文章
};

@interface HeroAppManager : NSObject

//单例
+(HeroAppManager *)shared;

/*
 游戏分享内容到【摸鱼社】编辑器
    title: 标题 【最多30个字符，多了会被截取】
    content:内容字符串 【最多40个字符，多了会被截取】
    shareContentType:URL内容类型 （枚举类型）【链接、图片】
    shareTitle:分享标题 【最多30个字符，多了会被截取】
    shareURL:分享链接/图片URL 注意：图片要上传到阿里云
    editorType:编辑器类型 （枚举类型）【动态帖、文章帖】
    gameId:游戏 ID ，如果当前游戏没有接入摸鱼社填写 “-1”
*/
- (void)openMoyuAppEditorWithTitle:(NSString *)title content:(NSString *)content shareContentType:(ShareContentType)shareType shareTitle:(NSString *)shareTitle shareURL:(NSString *)shareURL editorType:(EditorType)editorType fromGameId:(NSString *)gameId;


/*
 游戏分享内容到【皎皎角】编辑器
    title: 标题 【最多30个字符，多了会被截取】
    content:内容字符串 【最多40个字符，多了会被截取】
    shareContentType:URL内容类型 （枚举类型）【链接、图片】
    shareTitle:分享标题 【最多30个字符，多了会被截取】
    shareURL:分享链接/图片URL 注意：图片要上传到阿里云
    editorType:编辑器类型 （枚举类型）【动态帖、文章帖】
*/
- (void)openJJJiaoAppEditorWithTitle:(NSString *)title content:(NSString *)content shareContentType:(ShareContentType)shareType shareTitle:(NSString *)shareTitle shareURL:(NSString *)shareURL editorType:(EditorType)editorType;


/*
 游戏分享内容到【LunoLoft】编辑器 -- 海外二次元APP
    title: 标题 【最多30个字符，多了会被截取】
    content:内容字符串 【最多40个字符，多了会被截取】
    shareContentType:URL内容类型 （枚举类型）【链接、图片】
    shareTitle:分享标题 【最多30个字符，多了会被截取】
    shareURL:分享链接/图片URL 注意：图片要上传到阿里云
    editorType:编辑器类型 （枚举类型）【文章帖】
*/
- (void)openLunoLoftAppEditorWithTitle:(NSString *)title content:(NSString *)content shareContentType:(ShareContentType)shareType shareTitle:(NSString *)shareTitle shareURL:(NSString *)shareURL editorType:(EditorType)editorType;

@end



