//
//  HDCData.h
//  HDC
//
//  Created by Mr.Li on 16/7/25.
//  Copyright © 2016年 Li. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  所有SDK数据类型都为string类型，cp应当注意将其他类型数据转化为string传入BlocSDK
 */

@interface BlocData : NSObject

@end


@interface BlocItemCompose : NSObject

@property (nonatomic, copy  ) NSString * cid;   // cid ((原类型int) 可选)
@property (nonatomic, copy  ) NSString * name;  // 套装名称 （必须）
@property (nonatomic, copy  ) NSString * type;  // 类型 （必须）
@property (nonatomic, strong) NSArray  * items;  // 装备ID (原类型int 必须)

@end

@interface BlocBaseRoleInfoData : NSObject

@property (nonatomic, copy  ) NSString * roleName;      // 游戏角色名称 (string(20)
@property (nonatomic, copy  ) NSString * serverId;      // 游戏区服 (string(20)
@property (nonatomic, copy  ) NSString * roleId;        // 角色ID (string(20)
@property (nonatomic, copy  ) NSString * channelUserId; // 渠道用户ID (string(20)
@property (nonatomic, copy  ) NSString * gameUserId;    // CP账号Id (string(20)

@end

@interface BlocRoleInfoData : BlocBaseRoleInfoData

@property (nonatomic, copy  ) NSString * serverName;    // 游戏区服名称 (string(20))
@property (nonatomic, copy  ) NSString * roleAvatar;    // 角色头像 (string(20))
@property (nonatomic, copy  ) NSString * teamId;        // 战队ID  (string(45))
@property (nonatomic, copy  ) NSString * teamName;      // 战队名称 string(20)
@property (nonatomic, copy  ) NSString * level;         // 角色等级 (源类型int 例：@"1234")
@property (nonatomic, copy  ) NSString * levelExp;      // 当前经验值 (原类型long)
@property (nonatomic, copy  ) NSString * vipLevel;      // VIP等级 (原类型int)
@property (nonatomic, copy  ) NSString * vipScore;      // VIP积分 (原类型long)
@property (nonatomic, copy  ) NSString * rankLevel;     // 排位等级 (原类型int)
@property (nonatomic, copy  ) NSString * rankExp;       // 排位积分 (原类型long)
@property (nonatomic, copy  ) NSString * rankLevel2;    // 娱乐排位等级 (原类型int)
@property (nonatomic, copy  ) NSString * rankExp2;      // 娱乐排位积分 (原类型long)
@property (nonatomic, copy  ) NSString * cupCount1;     // 1类奖杯数量 (原类型int)
@property (nonatomic, copy  ) NSString * cupCount2;     // 2类奖杯数量 (原类型int)
@property (nonatomic, copy  ) NSString * totalKill;     // 总击杀数 (原类型int)
@property (nonatomic, copy  ) NSString * totalHead;     // 总爆头数 (原类型int)
@property (nonatomic, copy  ) NSString * avgKD;         // 平均击杀/死亡比 (原类型int，例如 12.34% *10000，则记录为1234)
@property (nonatomic, copy  ) NSString * maxKD;         // 最高击杀死亡比 ((原类型int，例如 12.34% *10000，则记录为1234))
@property (nonatomic, copy  ) NSString * maxCK;         // 最高连杀数 (原类型int)
@property (nonatomic, copy  ) NSString * mainWeaponId;  // 常用主武器ID (原类型int)
@property (nonatomic, copy  ) NSString * viceWeaponId;  // 常用副武器ID (原类型int)
@property (nonatomic, copy  ) NSString * gold1;         // 一级虚拟币 (long, 如钻石数量等)
@property (nonatomic, copy  ) NSString * gold2;         // 二级虚拟币 (long, 如钻石数量等)
@property (nonatomic, copy  ) NSString *sumPay;         // 充值金额
@property (nonatomic, strong) NSArray * medalCount;     // 勋章  (勋章a,b,c的数量 如@[@"1",@"4",@"3"])
@property (nonatomic, strong) NSArray * items;          // 所有装备 (传入id数组， 例@[@"1",@"3",@"4"])
@property (nonatomic, strong) NSArray * itemComposes;   // 套装 (数组元素为BlocItemCompose 数据类型)
@property (nonatomic, strong) NSDictionary *extend;     // 额外数据 (字典类型数据)
//(类似创造与魔法多角色上传，以最后一个上传角色为准m，显示小恐龙浮标-默认NO(需要显示)，YES(不显示))
@property (nonatomic, assign) BOOL floatHidden ;

@end

@interface BlocFighterData : NSObject

@property (nonatomic, copy  ) NSString * groupId;       // 所在队伍 (原类型int 比赛结束时所在队伍)
@property (nonatomic, copy  ) NSString * oriGroupId;    // 初始队伍ID (原类型int 赛前队伍,可以跟 groupId 一样)
@property (nonatomic, copy  ) NSString * serverId;      // 游戏区服 (string(20) 该参数成员所在区服)
@property (nonatomic, copy  ) NSString * roleId;        // 角色ID (string(60) 该参数成员角色ID)
@property (nonatomic, copy  ) NSString * roleAvatar;    // 角色头像 (该参数成员的头像)
@property (nonatomic, copy  ) NSString * result;        // 战果 (int 胜利(1)、失败(2)、逃跑(3)、平局(0)
@property (nonatomic, copy  ) NSString * kill;          // 击杀数 (原类型int) 生化跑酷模式时作为太阳勋章数
@property (nonatomic, copy  ) NSString * dead;          // 死亡数 (原类型int) 生化跑酷模式时作为石像勋章数
@property (nonatomic, copy  ) NSString * cup;           // 奖杯数据 (原类型int) 生化跑酷模式时作为皇冠勋章数
@property (nonatomic, copy  ) NSString * score;         // 积分增长 (原类型int)
@property (nonatomic, copy  ) NSString * level;         // 角色等级 (原类型int)
@property (nonatomic, copy  ) NSString * vipLevel;      // VIP等级 (原类型int)
@property (nonatomic, copy  ) NSString * rank;          // 排位 (原类型int)
@property (nonatomic, copy  ) NSString * rankInc;       // 排位积分变化 (原类型int)

@end

@interface BlocMatchData : NSObject

@property (nonatomic, copy  ) NSString * fightId;       // 战斗ID （string(45) CP系统为唯一）
@property (nonatomic, copy  ) NSString * roomId;        // 房间ID （必须 string类型）
@property (nonatomic, copy  ) NSString * sTime;         // 开始时间 (要求YYYYMMddHHmmss格式 可不填写)
@property (nonatomic, copy  ) NSString * eTime;         // 结束时间 (要求YYYYMMddHHmmss格式 可不填写)
@property (nonatomic, copy  ) NSString * type;          // 类型 (int转化字符串 如 房间战(0)或者是排位战(1)
@property (nonatomic, copy  ) NSString * mode;          // 模式 (原int类型)
@property (nonatomic, copy  ) NSString * scene;         // 场景ID (原类型int)
@property (nonatomic, copy  ) NSString * level;         // 难度等级 (原类型int)
@property (nonatomic, copy  ) NSString * count;         // 参数人数 (原类型int)
@property (nonatomic, copy  ) NSString * winner;        // 获胜队伍ID (原类型int)（0为平局）
@property (nonatomic, strong) NSArray * fighter;        // 参赛成员 (必须保持进场顺序)

@end

@interface BlocUserInfoData : NSObject

@property (nonatomic, copy  ) NSString * serverId;      // 游戏服务器ID (string(20) 源类型int)
@property (nonatomic, copy  ) NSString * roleId;        // 游戏角色ID (string(60) 源类型int)
@property (nonatomic, copy  ) NSString * channelUserId; // 渠道用户ID (string(45),渠道数定义,唯一)
@property (nonatomic, copy  ) NSString * gameUserId;    // 游戏用户ID 游戏用户ID
@property (nonatomic, copy  ) NSString * roleName;

@end

#pragma mark - post data

/**
 *  角色登录(playerlogin) SDK
 */
@interface BlocPlayerLoginData : NSObject

@property (nonatomic, copy  ) NSString * level;        //角色等级
@property (nonatomic, copy  ) NSString * vipLevel;     //vip等级
@property (nonatomic, copy  ) NSString * registDate;   //注册时间 格式必须为yyyyMMddHHmmss

@end

/**
 *  玩家支付(playerorder)
 */
@interface BlocPlayerOrderData : NSObject

@property (nonatomic, copy  ) NSString * orderId;     //cp订单号
@property (nonatomic, copy  ) NSString * thirdOrderId;//第三方订单号
@property (nonatomic, copy  ) NSString * state;       //状态 (默认-1， 成功 0 ， 取消 1， 失败 2  )
@property (nonatomic, copy  ) NSString * orderAmount; //订单金额 分为单位
@property (nonatomic, copy  ) NSString * currency;    //币种 缩略词 （大写） 例如 CNY
@property (nonatomic, copy  ) NSString * charge;      //对应获得的一级虚拟货币
@property (nonatomic, copy  ) NSString * donate;      //交易额外获得虚拟货币
@property (nonatomic, copy  ) NSString * goldType;    //虚拟货币类型 (0 -> 直接消费 1 -> 变成虚拟货币)
@property (nonatomic, copy  ) NSString * orderType;   //档位类型
@property (nonatomic, copy  ) NSString * roleName;    //角色名
@property (nonatomic, copy  ) NSString * level;       //角色等级
@property (nonatomic, copy  ) NSString * vipLevel;    //vip等级

@end

/**
 *  虚拟货币获得（goldobtain） SDK 实时
 */
@interface BlocGoldObtainData : NSObject

@property (nonatomic, copy  ) NSString * amount;            //关联的人民币价值 分为单位
@property (nonatomic, copy  ) NSString * currency;          //币种 缩略词 （大写） 例如 CNY
@property (nonatomic, copy  ) NSString * reason;            //获得原因 (0充值、1任务、2兑换、3其它)
@property (nonatomic, copy  ) NSString * subReason;         //子原因
@property (nonatomic, copy  ) NSString * goldDetailFree;    //免费获得的货币（变化量） long
@property (nonatomic, copy  ) NSString * goldDetailDonate;  //充值获得的额外赠送的货币（变化量）long
@property (nonatomic, copy  ) NSString * goldDetailCharge;  //充值直接获得的货币（变化量）long
@property (nonatomic, copy  ) NSString * goldCurrentFree;   //事件发生后免费钻石（总量）long
@property (nonatomic, copy  ) NSString * goldCurrentDonate; //事件发生后额外获得钻石（总量）long
@property (nonatomic, copy  ) NSString * goldCurrentCharge; //事件发生后充值直接获得钻石（总量）long
@property (nonatomic, copy  ) NSString * roleName;          //角色名
@property (nonatomic, copy  ) NSString * level;             //角色等级
@property (nonatomic, copy  ) NSString * vipLevel;          //vip等级

@end

/**
 *  玩家任务（playertask）
 */
@interface BlocPlayerTaskData : NSObject

@property (nonatomic, copy  ) NSString * taskType;   //任务类型 0 -> 新手任务 1 -> 主线任务 2 -> 每日任务 3 -> 特殊任务: 临时发布的运营任务等
@property (nonatomic, copy  ) NSString * taskId;     //任务类型ID
@property (nonatomic, copy  ) NSString * subTaskId;  //任务的步骤拆解  0表示任务开始
@property (nonatomic, copy  ) NSString * taskProgr;  //任务进度 时间任务用s表示

@end

/**
 *  玩家关卡
 */
@interface BlocPlayerStageData : NSObject

@property (nonatomic, copy  ) NSString * stageType;      //场景类型 0 --> 场景 1 --> 副本
@property (nonatomic, copy  ) NSString * stageId;        //场景ID
@property (nonatomic, copy  ) NSString * subStageId;     //子场景ID
@property (nonatomic, copy  ) NSString * stageCount;     //场景数量
@property (nonatomic, copy  ) NSString * resultType;     //0-》 失败 1 -》 成功 2 -》 其他（比如扫荡操作

@end

/**
 *  玩家战斗（playerfight）
 */
@interface BlocPlayerFightData : NSObject

@property (nonatomic, copy  ) NSString * fightType;        //战斗类型 0-> 房间战 1-> 排位战
@property (nonatomic, copy  ) NSString * fightMode;        //模式 如 “躲猫猫”， ”3V3“
@property (nonatomic, copy  ) NSString * fightMap;         //地图Id  (可选)
@property (nonatomic, copy  ) NSString * fightMusic;       //音乐Id  (可选)
@property (nonatomic, copy  ) NSString * fightLevel;       //难度等级

@end


/**
 *  自定义数据
 */
@interface BlocCustomData : NSObject

@property (nonatomic, copy  ) NSString * eventType;         //事件类型
@property (nonatomic, copy  ) NSString * eventSubType;      //子类
@property (nonatomic, copy  ) NSString * eventState;        //结果
@property (nonatomic, strong) NSDictionary * customEvent;   //事件体字典

@end

