//
//  BlocPlatform.h
//  BlocSDK
//
//  Created by Mr.Li on 16/6/21.
//  Copyright © 2016年 Li. All rights reserved.
//


/*
 * 文档地址: http://hero.doc.sdksrv.com/#!bloc/iOS_BlocSDK.md
 * 更新说明: http://hero.doc.sdksrv.com/#!bloc/iOS_History.md
 * SDK地址: http://hero.doc.sdksrv.com/#!bloc/index.md
 */

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

@class BlocMatchData;
@class BlocRoleInfoData;
@class BlocUserInfoData;
@class BlocConfig;

extern NSString * const BLOC_TAG_NOTIFICATION_RED;
extern NSString * const BLOC_TAG_NOTIFICATION;
extern NSString * const BLOC_TAG_NOTIFICATION_REL_STATE;
extern NSString * const BLOC_TAG_NOTIFICATION_CONFIGCOMPLETE;
extern NSString * const BLOC_GAME_VOICE_NEEDCLOSE;//监听游戏声音需要改变，YES关闭游戏声音 NO 打开游戏声音

@interface BlocPlatform : NSObject

+ (BlocPlatform *)sharedInstance;

@property (nonatomic, copy) NSString *javaServer; //java 服务器，请求配置参数等
@property (nonatomic, copy) NSString *phpServer;//php服务器，打开网页，红点等

#pragma mark - 共用模块(此模块必传)

/**
 *  初始化
 *  在此方法中调用- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
 *  @param config
 */
- (void)setConfig:(BlocConfig *)config;

/*
 *  二次拉取配置文件
 */
- (void)reloadSysModeSdk;

@property (nonatomic, copy) void (^sysModChangedBlock)();

//打开指定页面
@property (nonatomic, copy) void (^onSdkRedirectMessage)(NSString *action,id data);

//设置浮标位置
@property (nonatomic,assign) CGPoint floatBtnFrame;

/**
 *  设置用户登录信息 cp获取用户信息后优先调用此接口（此接口需优先于上传角色和角色上报调用）
 *  @param data
 */
- (void)setUserInfo:(BlocUserInfoData *)data;

#pragma mark - 攻略、赛事、社区模块（根据业务需要接入）
/*
 * 清除助手所有浮标
 */
- (void)clearBlocFloats;

/*
 *  是否显示小恐龙浮标
 */
- (void)needShowPhoneFloat:(BOOL)needShow ;
/**
 *  上传用户角色信息（cp获取角色后调用此接口,使用助手模块内容必须调用此接口）
 *  此接口可重复上报，cp在上报信息发生变化时还需调用此接口，例如：角色升级（10->11）
 *  @param roleInfoData 角色信息数据模型
 */
- (void)postRoleInfo:(BlocRoleInfoData *)roleInfoData;

/**
 *  上报比赛信息
 *
 *  @param matchData 比赛信息数据模型
 */
- (void)postMatch:(BlocMatchData *)matchData;

/**
 是否显示入口

 @param key 入口对应key值 （攻略：tactic  赛事：match  拉新：spread 商城：shop）对应值可咨询用户中心

 @return YES(是，显示) NO(否，隐藏)
 */
- (BOOL)showEntrance:(NSString *)key;

/**
 *  打开拉新模块
 *
 *  @param exitBlock 退出拉新模块
 */
- (void)openUserShareViewWithExit:(void (^)(void))exitBlock;

/**
 *  打开专区
 *
 *  @param action    action(必填)
 *  @param data      data(可选)
 *  @param module    必填，可根据对照表填写
 *  @param exitBlock 退出回调
 */
- (void)openForumViewWithAction:(NSString *)action data:(NSString *)data module:(NSString *)module exit:(void (^)(void))exitBlock;
/*
 *  直接传URL打开专区
 *
 *  @param openForumViewWithUrl 是否需要拼接公共参数
 *  @param exitBlock 退出回调
 */
- (void)openForumViewWithUrl:(NSString *)urlStr needCommonParamiters:(BOOL)needCommonParamiters exit:(void (^)(void))exitBlock;
/**
 打开URL地址网页
 @param urlString URL地址
 @param fromSDK 来自SDK
 @param exitCallBack 回调
 */
- (void)openForumViewWithUrlString:(NSString *)urlString fromSDK:(BOOL)fromSDK exitCallBack:(void(^)(void))exitCallBack ;

/**
 *  主动获取红点信息（被动使用通知 BLOC_TAG_NOTIFICATION_RED）
 *
 *  @param resBlock
 */
- (void)checkRedPoint:(void(^)())resBlock;

/**
 根据key值是否显示红点
 在通知中调用或- (void)checkRedPoint:(void(^)())resBlock;回调中使用
 @param key key

 @return yes为显示 no为隐藏
 */
- (BOOL)showRed:(NSString *)key;

#pragma -mark 关系链模块

/**
 打开邀请密友列表页面
 */
- (void)openRelationChainView;


/**
 打开邀请密友页面
 */
- (void)openAddressBookView;


/**
 密友列表：监测密友状态是否已经激活
 chainState = YES，已经激活
 chainState = NO，没有激活
 
 @param chainState chainState，BOOL值
 */
- (void)checkChainState:(void(^)(BOOL state))chainState;

/*
 *  =============================================枪战专用API============================================================
 */
//小队
- (void)getTeamsListWithSuccess:(void (^)(id obj))success
                        failure:(void (^)(id obj))failure;
//排行榜（个人）
- (void)getTopListWithPage:(int)page
                  pageSize:(int)pageSize
                   matchid:(NSString *)matchid
                   Success:(void (^)(id obj))success
                   failure:(void (^)(id obj))failure;
//比赛记录
- (void)getMatchRecordListWithPage:(int)page
                          pageSize:(int)pageSize
                           matchid:(NSString *)matchid
                           Success:(void (^)(id obj))success
                           failure:(void (^)(id obj))failure;
//当前所有进行中的比赛
- (void)getMatchListWithSuccess:(void (^)(id obj))success
                        failure:(void (^)(id obj))failure;
//排行榜（小队）
- (void)getTeamTopListWithPage:(int)page
                      pageSize:(int)pageSize
                       matchid:(NSString *)matchid
                       Success:(void (^)(id obj))success
                       failure:(void (^)(id obj))failure;
@end

