//
//  HeroFloatPlatform.h
//  HeroFloatSDK
//
//  Created by 魏太山 on 2020/12/21.
//  Copyright © 2020 Hero. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef void (^HSuccessBlock)(NSDictionary *result);
typedef void (^HFailureBlock)(NSString *err);

// 切换小号通知
extern NSString * const HFLOAT_PUBLIC_CODE_SWITCH_SUB_ACCOUNT;
// 退出通行证通知
extern NSString * const HFLOAT_PUBLIC_CODE_EXIT_ACCOUNT;
// 切换账号通知
extern NSString * const HFLOAT_PUBLIC_CODE_SWITCH_ACCOUNT;

@interface HeroFloatPlatform : NSObject

+ (HeroFloatPlatform *)sharedInstance;

/**初始化浮标信息*/
- (void)initFloatConfigWithInfo:(NSDictionary *)info;
/**隐藏浮标*/
- (void)hide;
/** 是否是圆圈 */
@property (nonatomic, assign) BOOL isCircle;
#pragma mark - 接口信息

/**
 * 获取通行证信息
 * eg：
 * {
 *  "success": true,
 *  "code": 0,
 *  "data": {
 *   "no": "HM2021052711247", //通行证ID
 *   "sub": 0,                //独立数据库，0为默认，代表公共数据库
 *   "loginType": 1,          //登录方式
 *   "logoutSubCount": 0,     //当前注销小号数量
 *   "fullTel": "17360170816",//手机号，不带*号
 *   "subId": "269063614",    //当前登录小号ID
 *   "maxSubCount": 5,        //最大小号限制
 *   "tel": "173****0816",    //手机号，带*号
 *   "curSubCount": 2         //当前小号个数
 *        },
 *  "timestamp": 1623995843208
 * }
 * @param success 成功回调
 * @param failure 失败回调
 */
- (void)getPassCardInfoWithSuccess:(HSuccessBlock)success
                           failure:(HFailureBlock)failure;

/**
 * 获取手机验证码(只是验证)
 * @param success 成功回调
 * @param failure 失败回调
 */
- (void)getPhoneCodeJustVerifyWithSuccess:(HSuccessBlock)success
                                  failure:(HFailureBlock)failure;

/**
 * 验证手机验证码(只是验证)
 * @param code    验证码
 * @param success 成功回调
 * @param failure 失败回调
 */
- (void)verifyPhoneCodeJustVerifyWithCode:(NSString *)code
                                  success:(HSuccessBlock)success
                                  failure:(HFailureBlock)failure;

/**
 * 获取手机验证码（手动输入手机号时调用）
 * @param phoneNo 手机号
 * @param success 成功回调
 * @param failure 失败回调
 */
- (void)getPhoneCodeWithPhoneNo:(NSString *)phoneNo
                        success:(HSuccessBlock)success
                        failure:(HFailureBlock)failure;

/**
 * 验证手机验证码(手动输入手机号时调用)
 * @param phoneNo 手机号
 * @param code    验证码
 * @param success 成功回调
 * @param failure 失败回调
 */
- (void)verifyPhoneCodeWithPhoneNo:(NSString *)phoneNo
                              code:(NSString *)code
                           success:(HSuccessBlock)success
                           failure:(HFailureBlock)failure;

/**
 * 获取手机验证码(换绑手机时调用)
 * @param success 成功回调
 * @param failure 失败回调
 */
- (void)getPhoneCodeWhenPhoneChangeBindWithSuccess:(HSuccessBlock)success
                                           failure:(HFailureBlock)failure;

/**
 * 验证手机验证码(换绑手机时调用)
 * @param code    验证码
 * @param success 成功回调
 * @param failure 失败回调
 */
- (void)verifyPhoneCodeWhenPhoneChangeBindWithCode:(NSString *)code
                                           success:(HSuccessBlock)success
                                           failure:(HFailureBlock)failure;

/**
 * 获取小号列表
 *{
 *  "code" : 0,
 *  "data" : {
 *    "list" : [
 *      {
 *        "name" : "U30000867A_3",      //显示的名称
 *        "uid" : "91627811_3",         //小号ID
 *        "loginName" : "U30000867A_3", //登录名字
 *        "mid" : 222,                  //通行证主键ID
 *        "sub" : 0,                    //独立数据库，0为默认，代表公共数据库
 *        "updateTime" : 1622108860000, //更新时间戳
 *        "id" : 19,
 *        "sdkUserId" : "U30000867A_3", //用户ID
 *        "gid" : 1000,                 //游戏ID
 *        "createTime" : 1622108860000  //创建时间戳
 *      }
 *    ]
 *  },
 *  "timestamp" : 1624256160814,
 *  "success" : true
 *}
 * @param success 成功回调
 * @param failure 失败回调
 */
- (void)getSubListWithSuccess:(HSuccessBlock)success
                      failure:(HFailureBlock)failure;

@end

NS_ASSUME_NONNULL_END
