//
//  UOPShareDefine.h
//  Pods
//
//  Created by yuwei.will on 2023/11/9.
//

#ifndef UOPShareDefine_h
#define UOPShareDefine_h

typedef NS_ENUM(NSInteger, UOPThirdShareType) {
    UOPThirdShareTypeDouyin
};

// 支持的内容类型
typedef NS_ENUM(NSInteger, UOPShareDouyinContentType) {
    UOPShareDouyinContentTypeVideo, // 视频
    UOPShareDouyinContentTypeImage, // 图片
    UOPShareDouyinContentTypeImageVideo, // 图片视频混合
};

// 分享至抖音
typedef NS_ENUM(NSInteger, UOPShareDouyinWay) {
    UOPShareDouyinWayPublish, // 发布到至抖音
    UOPShareDouyinWayIM,      // 发送给抖音好友
    UOPShareDouyinWayCapture, // 打开抖音拍摄器
};

typedef NS_ENUM(NSInteger, UOPShareErrorCode) {
    UOPShareSuccess                = 0,  // 正常
    UOPShareErrorCodeCommon        = -1, // 通用错误
    UOPShareErrorCodeUserCanceled  = -2, // 用户手动取消
    UOPShareErrorCodeSendFailed    = -3, // 发送失败
    UOPShareErrorCodeAuthDenied    = -4, // 分享权限或相册权限异常
    UOPShareErrorCodeUnsupported   = -5, // 不支持
    UOPShareErrorCodeNotInstalled  = -6, // 抖音未安装
    
    UOPShareErrorCodeNotRegister   = -100, // 未初始化
    UOPShareErrorCodeSystemOff     = -101, // 云控关闭
    UOPShareErrorCodeMediaUnavailable = -103, // 文件资源错误
};

#endif /* UOPShareDefine_h */
