//
//  UOPShareManager.h
//  UnionOpenPlatform
//
//  Created by ByteDance on 2021/6/7.
//

#import <Foundation/Foundation.h>
#import <UnionOpenPlatformShare/UOPShareBaseContent.h>
#import <UnionOpenPlatformShare/UOPShareResponse.h>

NS_ASSUME_NONNULL_BEGIN

/// 分享模块依赖授权模块，需要前置完成授权模块能力的接入

@interface UOPShareManager : NSObject

+ (instancetype)sharedManager;

/// 执行分享操作
/// @param content 分享内容
/// @param completion 分享行为完成回调
- (void)shareContent:(UOPShareBaseContent *)content completion:(void(^)(UOPShareResponse *))completion;

@end

NS_ASSUME_NONNULL_END
