/*
 * Copyright (C) 2017 Twitter, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/**
 This header is private to the Twitter Kit SDK and not exposed for public SDK consumption
 */

#import <Foundation/Foundation.h>

#pragma mark - Twitter kit constants

FOUNDATION_EXTERN NSString *const TWTRVersion;
FOUNDATION_EXTERN NSString *const TWTRResourceBundleLocation;
FOUNDATION_EXTERN NSString *const TWTRBundleID;

#pragma mark - User messages

FOUNDATION_EXTERN NSString *const TWTRMissingKitInfoMsg;
FOUNDATION_EXTERN NSString *const TWTRMissingConsumerKeyMsg;
FOUNDATION_EXTERN NSString *const TWTRMissingConsumerSecretMsg;

#pragma mark - Twitter API

FOUNDATION_EXTERN NSString *const TWTRAPIRateLimitHeader;
FOUNDATION_EXTERN NSString *const TWTRAPIRateLimitRemainingHeader;
FOUNDATION_EXTERN NSString *const TWTRAPIRateLimitResetHeader;

#pragma mark - Kit Info

FOUNDATION_EXTERN NSString *const TWTRKitInfoConsumerKeyKey;
FOUNDATION_EXTERN NSString *const TWTRKitInfoConsumerSecretKey;

#pragma mark - URL Referrer

FOUNDATION_EXTERN NSString *const TWTRURLReferrer;
