//
//  HeroAccountModel.h
//  HeroGlobal
//
//  Created by 谢宗文 on 2017/8/30.
//  Copyright © 2017年 谢宗文. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface HeroAccountModel : NSObject

@property (nonatomic, copy) NSString *suid;
@property (nonatomic, copy) NSString *uid;
@property (nonatomic, copy) NSString *status;
@property (nonatomic, copy) NSString *pwdStatus;   /** 密码状态 1：已设置，0：未设置 */
@property (nonatomic, copy) NSString *accessToken;
@property (nonatomic, copy) NSString *thirdToken;//第三方登录成功后的token
@property (nonatomic, copy) NSString *accountType;//0.游客 1.facebook 2.谷歌  3.GameCenter 4.微信 5.推特 7.Apple 8.line
@property (nonatomic, copy) NSString *loginCount;//登录次数
@property (nonatomic, copy) NSString *userName;//第三方账号用户名
@property (nonatomic, copy) NSString *loginTime;//上次登录时间
@property (nonatomic, copy) NSString *gameId;//游戏ID
//备用字段
@property (nonatomic, copy) NSString *placeHolder1;//目前记录账号状态
@property (nonatomic, copy) NSString *password;
//判断三方账号唯一标识
@property (nonatomic, copy) NSString *cuid;
/** 是否弹游客绑定,bind `0：不彈綁定、1：彈綁定` */
@property (nonatomic, copy) NSString *touristBind;

/** 注销状态, 0为未注销，1为注销中*/
@property (nonatomic, assign) NSInteger logoutStatus;

/** 是否弹窗协议，数组为空不弹窗
 @[
 @{
 @"text" : @"（必填）阅读并同意$1《用户协议》1$$2《隐私协议》2$",
 @"agrUrls" : @[@"http://xxx", @"http://xxx2"],
 @"require" : @1,
 @"type" : @"mainAgr"
 },
 @{
 @"text" : @"（必填）我已年满14周岁",
 @"agrUrls" : @[],
 @"require" : @1,
 @"type" : @"age"
 },
 @{
 @"text" : @"同意此遊戲以信件的形式寄送遊戲$最新咨詢$",
 @"agrUrls" : @[@"http://xxx"],
 @"require" : @0,
 @"type" : @"push"
 }
 ],
 */
@property (nonatomic, strong) NSArray *agrContent;

/**
 营销协议和push协议，账号中心使用
 pushAgr =     (
 {
 enable = 1;
 text = "\U540c\U610f\U63a5\U6536\U6d3b\U52a8\U7b49$1\U63a8\U9001\U901a\U77e51$\U3002";
 type = pushAgr;
 }
 );
 */
@property (nonatomic, strong) NSArray *pushAgrContent;

/** 注销时间 */
@property (nonatomic, copy) NSString *logoutCreateTime;
/** 注销执行时间 */
@property (nonatomic, copy) NSString *logoutSubActionTime;
/** 新增，游客支付前是弹绑定, 默认0，1开，0关 */
@property (nonatomic, assign) BOOL payBind;
/** 新增，是否绑定邮箱, 0未绑定，1已绑定 */
@property (nonatomic, assign) BOOL mailBind;

/** 返回 11，表示客户端需要进行安全验证（服务端已成功发送安全验证码到登录邮箱） ；
    返回 12 表示安全验证码校验失败  ；
    返回 13 表示服务端主动发送邮箱安全验证码失败了 ; */
@property (nonatomic, assign) NSInteger emailPdLoginRisk;

@property (nonatomic, copy) NSString *msg;

@end
