//
//  HGCommonPlatform.h
//  HeroGlobal
//
//  Created by 谢宗文 on 2017/9/1.
//  Copyright © 2017年 谢宗文. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HGIAPManager.h"
#import "HeroAccountModel.h"
#import "HeroShareModel.h"
#import "HGRoleInfo.h"
#import "HGPUSHService.h"
#import <UIKit/UIKit.h>
#import "HGSwiftBridgeManager.h"
#import "HeroIAPModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface HeroPlatform : NSObject

+ (HeroPlatform *)sharedInstance;

// 是否打印 log，默认是 YES，打印
-(void)enableLog:(BOOL)yesToEnable;

/*
 *  初始化SDK
 */
- (void)initHeroWithGameId:(NSString *)gameId      /** 游戏id(必填 游戏ID,SDK产品提供 ) */
               productCode:(NSString *)productCode /** SDK服务端为每个应用分配的产品id */
                productKey:(NSString *)productKey /** SDK服务端为每个应用分配的私钥 */
                 projectId:(NSString *)projectId; /** SDK服务端为每个应用分配的projectId */

/*
 *  新初始化SDK，游客账号迁移使用
 */
- (void)initHeroWithGameId:(NSString *)gameId      /** 游戏id(必填 游戏ID,SDK产品提供 ) */
               productCode:(NSString *)productCode /** SDK服务端为每个应用分配的产品id */
                productKey:(NSString *)productKey /** SDK服务端为每个应用分配的私钥 */
                 projectId:(NSString *)projectId /** SDK服务端为每个应用分配的projectId */
                     cpUid:(NSString *)cpUid;/** 原游客Id，迁移账号使用 */

/** 屏幕支持方向，默认是 UIInterfaceOrientationMaskAll */
@property (nonatomic, assign) UIInterfaceOrientationMask supportedInterfaceOrientations;

/** 触发系统边缘手势，默认是 UIRectEdgeNone*/
@property (nonatomic, assign) UIRectEdge preferredScreenEdgesDeferringSystemGestures;

/** 是否是纯净版本 */
@property (nonatomic, assign) BOOL isPureVersion;

/** 渠道ID */
@property (nonatomic, copy) NSString *cid;

/*
 *  服务器地址，在init方法之前设置
 */
@property (nonatomic, copy) NSString *urlServer;
/*
 *  灾备服务器地址，包含主服务器设置，在init方法之前设置
 */
@property (nonatomic, strong) NSArray<NSString *> *backupUrls;
/*
 *  埋点服务器地址，在init方法之前设置
 */
@property (nonatomic, copy) NSString *trackUrl;
/*
 *  twitterKey
 */
@property (nonatomic, copy) NSString *twitterKey ;
/*
 *  twitterSecret
 */
@property (nonatomic, copy) NSString *twitterSecret ;

/*
 *  googleClientID
 */
@property (nonatomic, copy) NSString *googleClientID;

/*
 *  vkClientID
 */
@property (nonatomic, copy) NSString *vkClientID;

/*
 *  vkClientSecret
 */
@property (nonatomic, copy) NSString *vkClientSecret;

@property (nonatomic, copy) NSString *tiktokUniversalLink;

@property (nonatomic, strong) NSDictionary *launchOptions;

//设置界面分享方式YES 代表关闭该分享方式 默认打开
/*
*  是否关闭Facebook分享
*/
@property (nonatomic, assign) BOOL closeFacebook;
/*
*  是否关闭Twitter分享
*/
@property (nonatomic, assign) BOOL closeTwitter ;
/*
*  是否关闭LINE分享
*/
@property (nonatomic, assign) BOOL closeLINE ;

/**
 *  静默登录开关，默认关闭，开启后(设置为YES)，登录成功后，不会显示上方横条
 */
@property (nonatomic, assign) BOOL quiesceLogin;

/**
 *  新登录界面开关，newStyleLogin 为2时为新界面，为0和1是保持不变
 */
@property (nonatomic, assign) NSInteger newStyleLogin;

/**
 *  主题风格，0为默认风格，1为黑金风格
 */
@property (nonatomic, assign) NSInteger themeStyle;

/*
 *  登录，如果有历史账号，会自动登录最近的账号
 */
- (void)showLoginView;

/*
 *  切换到登录界面
 */
- (void)switchLoginView;

/*
 *  切换到历史登录界面
 */
- (void)switchHistoryLoginView;

/*
 *  账号删除
 *  调用此接口会弹出删除账号界面，删除账号后服务器也会删除，请谨慎操作
 */
- (void)accountCancellation;

/*
 *  配置是否显示游客登录入口,在showLoginView方法之前调用
    服务器如果关闭游客登录，则此配置无效
 */
- (void)configTouristButtonShow:(BOOL)show;

/* 
 *  支付
 */
- (void)payWithIapModel:(HeroPayModel *)iapModel;

/*
 *  绑定账号
 */
- (void)bindAccount;

/*
 *  账号中心
 *  登录后才可调用
 *  调用此方法会打开账号中心界面，可进行绑定，注销等操作
 */
- (void)showAccountCenter;

/*
 *  清除本地账号
 */
- (void)cleanAccount;

/*
 *  註銷
 */
- (void)logout;

/*
 *  suid设置密码带界面
 */
- (void)showSetPassViewWithSuccess:(void (^)(id obj))success
                           failure:(void (^)(id obj))failure ;

/*
 *  suid账号+密码登录(带界面)
 */
- (void)showUidLoginViewWithSuccess:(void (^)(id obj))success
                            failure:(void (^)(id obj))failure;

/** 邮箱登录接口  */
- (void)showEmailLoginViewWithSuccess:(void (^)(HeroAccountModel *obj))success
                              failure:(void (^)(NSString *error))failure;

/**
 *  此函数应该在AppDelegate里面被调用.（ios8）
 */
-(BOOL)application:(UIApplication *)application
           openURL:(NSURL *)url
 sourceApplication:(NSString *)sourceApplication
        annotation:(id)annotation;

/**
 *  此函数应该在AppDelegate里面被调用.（ios9以后）
 */
- (BOOL)application:(UIApplication *)app
            openURL:(NSURL *)url
            options:(NSDictionary<NSString*, id> *)options;
/**
 *  此函数应该在AppDelegate里面被调用.（ios7以下）
 */
- (BOOL)application:(UIApplication *)application handleOpenURL:(NSURL *)url;

- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void (^)(NSArray<id<UIUserActivityRestoring>> * _Nullable))restorationHandler;

/*
 * 监听游戏从后台返回
 */
- (void)applicationWillEnterForeground:(UIApplication *)application;

/*
 *  主动查询小票，进行补单，有界面
 */
- (void)queryTicket;

/**
 * 上报问题
 */
- (void)uploadIssue;

/**
 * 设置角色信息
 */
- (void)setRoleInfo:(HGRoleInfo *)info;

/**
 *  提供给USDK调用设置角色信息 HGRoleInfo，避免版本不一致导致闪退
 */
- (void)usdkSetRoleInfo:(id)info;

/**
 * @abstract
 * 调用 track 接口，追踪一个带有属性的 event
 *
 * @discussion
 * propertyDict 是一个 Map。
 * 其中的 key 是 Property 的名称，必须是 NSString
 * value 则是 Property 的内容，只支持 NSString、NSNumber、NSSet、NSArray、NSDate 这些类型
 *
 * @param event            event的名称
 * @param propertyDict     event的属性
 */
- (void)track:(NSString *)event withProperties:(nullable NSDictionary *)propertyDict;

/**
 获取全埋点数据
 */
- (void)trackEventDataCallback:(void (^)(NSDictionary *data))callback;

/* 
 *  打开Xsolla商城支付
 *  @param iapModel          serverId和roleName、roleId必传
 *  @param cpUid             游戏用户id
 *  @param isJumpOutBrowser  是否跳转外部浏览器，YES为外部浏览器，NO为内置浏览器
 */
- (void)startXsollaPayWithIapModel:(HeroPayModel *)iapModel cpUid:(NSString *)cpUid isJumpOutBrowser:(BOOL)isJumpOutBrowser;

#pragma mark - 分享

/**
 *  Facebook 分享链接
 *
 *  @param linkUrl     分享的链接
 *  @param caption     分享的标题
 *  @param description 分享的描述.
 *  @param pictureUrl  图片链接地址
 *  @param completion     回调
 */

- (void)fbShareLink:(NSString *)linkUrl
            caption:(NSString *)caption
        description:(NSString *)description
         pictureUrl:(NSString *)pictureUrl
         completion:(void(^)(NSDictionary *resultData,NSError *error,BOOL isCancle))completion;

/**
 *  Facebook 分享照片
 *
 *  @param image     分享的照片
 *  @param completion     回调
 */

- (void)fbShareImage:(UIImage *)image
          completion:(void(^)(NSDictionary *resultData,NSError *error,BOOL isCancle))completion;

/**
 *  Facebook 分享视频
 *
 *  @param videoUrl     分享的视频的NSURL
 *  @param completion     回调
 */

- (void)fbShareVideoUrl:(NSURL *)videoUrl
             completion:(void(^)(NSDictionary *resultData,NSError *error,BOOL isCancle))completion;

/*
 *  用户协议
*/
- (NSString *)getUserAgreement ;
/*
 * 隐私协议
 */
- (NSString *)getPrivacyAgreement ;
/*
 * 游戏管理
*/
- (NSString *)getGameManagementAgreement ;

/*
 * 有分享界⾯面 - shareModels为分享数据模型，包含分享链接、描述、分享类型等必要参数
 * success成功回调 failure失败回调
 */
- (void)showShareViewWithShareDataArray:(NSArray *)shareModels
                           success:(void(^)(NSString *successMessage,HeroShareStatus status,HeroShareTaget target))success
                           failure:(void(^)(NSString *failureMessage,HeroShareStatus status,HeroShareTaget target))failure;
/*
 * 分享--⽆无分享界⾯面
 * shareModel为分享数据模型，包含分享链接、描述、分享类型等必要参数
 * success成功回调 failure失败回调 */
- (void)shareWithShareData:(HeroShareModel *)shareModel
                   success:(void(^)(NSString *successMessage,HeroShareStatus status,HeroShareTaget target))success
                   failure:(void(^)(NSString *failureMessage,HeroShareStatus status,HeroShareTaget target))failure;

/*
 *  ==============================以下是给游戏直接调用的接口，需要游戏自己绘制界面======================================
 */
#pragma mark - 无界面接口
/*
 *  登录(本地无账号时-默认游客登录，切换账号后使用上一次账号登录)
 */
- (void)startJpVloginWithSuccess:(void (^)(id obj))success
                         failure:(void (^)(id obj))failure ;

/*
 *  登录 loginType 为登录类型
 */
- (void)starLoginWithType:(LoginType )loginType
             needRegister:(void (^)(BOOL needRegister))needRegister
                  Success:(void (^)(id obj))success
                  failure:(void (^)(id obj))failure;

/*
 *  设置密码-当前账号必须先登录，适用于引继码
 */
- (void)setCurrentAccountPass:(NSString *)pass
                      Success:(void (^)(id obj))success
                      failure:(void (^)(id obj))failure ;

/*
 *  引继码登录(suid登录)
 */
- (void)startLoginWithSuid:(NSString *)suid
                      pass:(NSString *)pass
                   Success:(void (^)(id obj))success
                   failure:(void (^)(id obj))failure;

/*
 *  账号密码登录
 */
- (void)startLoginWithAccount:(NSString *)account
                     password:(NSString *)password
                      success:(void (^)(id obj))success
                      failure:(void (^)(id obj))failure;
/*
 *  绑定类型
 */
- (void)bindAccountWithType:(BindType )bindType
                    Success:(void (^)(NSDictionary* result))success
                    failure:(void (^)(NSString* error))failure;

/*
 *  解绑类型
 */
- (void)unBindAccountWithType:(BindType )bindType
                      Success:(void (^)(NSDictionary* result))success
                      failure:(void (^)(NSString* error))failure ;

/*
 *  账号注册
 */
- (void)registerAccountWithType:(LoginType )loginType
                        Success:(void (^)(id obj))success
                        failure:(void (^)(id obj))failure;
/*
 *  切换账号
 */
- (void)switchAccountWithType:(LoginType )loginType
                      Success:(void (^)(id obj))success
                      failure:(void (^)(id obj))failure;

/*
 *  获取绑定状态
 */
- (void)getBindStateWithSuccess:(void (^)(NSDictionary* result))success
                        failure:(void (^)(NSString* error))failure;

/**
 *  解除【账号删除】状态，将账号恢复成正常账号
 */
- (void)accountUnCancellationWithSuccess:(void (^)(NSDictionary* result))success
                                 failure:(void (^)(NSString* error))failure;

/**
 自定义logo
 将.png后缀的@2x和@3x图片直接拖到工程，然后传入logoName即可，不需要后缀
 @param logoName logo文件名
 @return 错误信息
 */
- (NSString *)setLogoWithName:(NSString *)logoName;

/** 绑定邮箱功能-安全邮箱绑定，不涉及登录，登录邮箱绑定不能调用此接口 */
- (void)bindEmailWithSuccess:(void (^)(NSDictionary *result))success
                     failure:(void (^)(NSString *error))failure;

/**
 设置SDK语言
 **/
- (void)setLanguageType:(HeroLanguageType)languageType;

/** 获取苹果商品列表**/
- (void)getAppleSkuDetailsList:(NSArray<NSString *> *)gameGoodsList
                       success:(void (^)(NSArray<NSString *> *))success
                       failure:(void (^)(NSString *error))failure;

#pragma mark - 无界面接口-新接口

/**
 * 新无界面登录； 检查本地是否有缓存账号
 */
- (BOOL)checkCacheAccount;

/**
 * 新无界面登录； 缓存登录接口(本地无账号时-默认游客登录，有账号时，使用最近登录过的账号登录)
 */
- (void)startV2CacheLoginWithSuccess:(void (^)(HeroAccountModel *model))success
                             failure:(void (^)(NSString *error))failure;

/**
 * 新无界面登录；指定 loginType 登录
 */
- (void)startV2LoginWithType:(LoginType)loginType
                    success:(void (^)(HeroAccountModel *model))success
                    failure:(void (^)(NSString *error))failure;

/**
 * 新无界面登录；切换账号
 */
- (void)startV2SwitchAccountWithType:(NSUInteger)loginType
                             success:(void (^)(HeroAccountModel *model))success
                             failure:(void (^)(NSString *error))failure;

/**
 * 新无界面登录；邮箱密码登录
 登录时model.emailPdLoginRisk=11,12,13时，表示用户更换了设备登录，会导致登录失败，需要跳转到邮箱安全验证界面，重新发起[触发安全验证时登录]
 返回 11，表示客户端需要进行安全验证（服务端已成功发送安全验证码到登录邮箱） ；
 返回 12 表示安全验证码校验失败  ；
 返回 13 表示服务端主动发送邮箱安全验证码失败了 ;
 */
- (void)startV2EmailLoginWithEmail:(NSString *)email
                          password:(NSString *)password
                           success:(void (^)(HeroAccountModel *model))success
                           failure:(void (^)(NSString *error))failure;

/**
 * 新无界面登录；触发安全验证时登录
 */
- (void)startV2EmailSecurityLoginWithEmail:(NSString *)email
                                  password:(NSString *)password
                                      code:(NSString *)code
                                   success:(void (^)(HeroAccountModel *model))success
                                   failure:(void (^)(NSString *error))failure;

/**
 * 新无界面登录；邮箱验证码登录
 */
- (void)startV2EmailCodeLoginWithEmail:(NSString *)email
                                  code:(NSString *)code
                               success:(void (^)(HeroAccountModel *model))success
                               failure:(void (^)(NSString *error))failure;

/**
 * 新无界面登录；获取邮箱验证码
 * HGEmailCodeTypeLogin,     邮箱验证码 登录
 * HGEmailCodeTypeBind,      邮箱验证码 绑定
 * HGEmailCodeTypeUnBind,    邮箱验证码 解绑
 * HGEmailCodeTypeSetPwd,    邮箱验证码 设置密码
 * HGEmailCodeTypeUpdatePwd, 邮箱验证码 更新密码
 * HGEmailCodeTypeSecurity,  邮箱验证码 换设备触发安全验证
 *
 */
- (void)getEmailCodeV2WithEmail:(NSString *)email
                           type:(HGEmailCodeType)type
                        success:(void (^)(NSDictionary *result))success
                        failure:(void (^)(NSString *error))failure;

/** 新无界面登录；校验验证码真实性 */
- (void)checkEmailAuthCodeWithEmail:(NSString *)email
                               code:(NSString *)code
                            success:(void (^)(NSDictionary *result))success
                            failure:(void (^)(NSString *error))failure;

/** 新无界面登录；绑定邮箱 */
- (void)emailBindWithEmail:(NSString *)email
                  password:(NSString *)password
               verifyToken:(NSString *)verifyToken
                   success:(void (^)(NSDictionary *result))success
                   failure:(void (^)(NSString *error))failure;

/** 新无界面登录；解绑邮箱 */
- (void)emailUnBindWithEmail:(NSString *)email
                 verifyToken:(NSString *)verifyToken
                     success:(void (^)(NSDictionary *result))success
                     failure:(void (^)(NSString *error))failure;

/** 新无界面登录；设置邮箱密码
 *  @type 1为设置密码，0为更新密码
 */
- (void)setEmailPasswordWithEmail:(NSString *)email
                         password:(NSString *)password
                      verifyToken:(NSString *)verifyToken
                             type:(NSInteger)type
                          success:(void (^)(NSDictionary *result))success
                          failure:(void (^)(NSString *error))failure;
@end

NS_ASSUME_NONNULL_END
